package com.biz.crm.sfa.business.overtime.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.mapper.OvertimeApplyMapper;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyConditionDto;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 加班申请表的数据库访问类 {@link OvertimeApplyEntity}
 *
 * @author ning.zhang
 * @date 2022-05-30 11:05:25
 */
@Component
public class OvertimeApplyRepository extends ServiceImpl<OvertimeApplyMapper, OvertimeApplyEntity> {

  /**
   * 根据条件查询加班申请信息
   *
   * @param dto 参数dto
   * @return 加班申请信息
   */
  public List<OvertimeApplyEntity> findByOvertimeApplyConditionDto(OvertimeApplyConditionDto dto) {
    return this.baseMapper.findByOvertimeApplyConditionDto(dto);
  }

  /**
   * 根据申请编码获取申请实体
   *
   * @param applyCode  申请编码
   * @param tenantCode 租户编码
   * @return 申请实体
   */
  public OvertimeApplyEntity findByApplyCode(String applyCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(OvertimeApplyEntity::getTenantCode, tenantCode)
        .eq(OvertimeApplyEntity::getApplyCode, applyCode)
        .one();
  }
}
