package com.biz.crm.sfa.business.overtime.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeRuleEntity;
import com.biz.crm.sfa.business.overtime.local.mapper.OvertimeRuleMapper;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 加班考勤规则关系表的数据库访问类 {@link OvertimeRuleEntity}
 *
 * @author ning.zhang
 * @date 2022-05-30 15:30:33
 */
@Component
public class OvertimeRuleRepository extends ServiceImpl<OvertimeRuleMapper, OvertimeRuleEntity> {

  /**
   * 通过遵守标识获取加班遵守考勤规则信息
   *
   * @param abideFlag  遵守标识
   * @param tenantCode 租户编码
   * @return 加班遵守考勤规则信息
   */
  public List<OvertimeRuleEntity> findByAbideFlag(String abideFlag, String tenantCode) {
    return this.lambdaQuery()
        .eq(OvertimeRuleEntity::getAbideFlag, abideFlag)
        .eq(OvertimeRuleEntity::getTenantCode, tenantCode)
        .list();
  }

  /**
   * 通过考勤规则编码获取加班遵守考勤规则信息
   *
   * @param ruleCodes  考勤规则编码
   * @param tenantCode 租户编码
   * @return 加班遵守考勤规则信息
   */
  public List<OvertimeRuleEntity> findByRuleCodes(Set<String> ruleCodes, String tenantCode) {
    return this.lambdaQuery()
        .in(OvertimeRuleEntity::getRuleCode, ruleCodes)
        .eq(OvertimeRuleEntity::getTenantCode, tenantCode)
        .list();
  }

  /**
   * 通过考勤规则编码删除考勤规则与加班关联信息
   *
   * @param ruleCodes  考勤规则编码
   * @param tenantCode 租户编码
   */
  public void deleteByRuleCodes(Set<String> ruleCodes, String tenantCode) {
    this.lambdaUpdate()
        .in(OvertimeRuleEntity::getRuleCode, ruleCodes)
        .eq(OvertimeRuleEntity::getTenantCode, tenantCode)
        .remove();
  }
}
