package com.biz.crm.sfa.business.overtime.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.time.format.DateTimeFormatter;

/**
 * 加班常量
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class OvertimeConstant {

  /**
   * 12:00:00
   */
  public static final String TIME_STR_120000 = "12:00:00";
  /**
   * 每天最早的时刻
   */
  public static final String TIME_STR_000000 = "00:00:00";
  /**
   * 每天最晚的时刻
   */
  public static final String TIME_STR_235959 = "23:59:59";
  /**
   * 时间日期格式 yyyy-MM-dd HH:mm:ss
   */
  public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM-dd
   */
  public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
  /**
   * 时间日期格式 HH:mm:ss
   */
  public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM
   */
  public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyy-MM");
  /**
   * 时间日期格式 yyyy
   */
  public static final DateTimeFormatter YYYY = DateTimeFormatter.ofPattern("yyyy");
  /**
   * 加班模块key
   */
  public static final String OVERTIME_KEY = "overtime";
  /**
   * 加班申请发起流程来源类型
   */
  public static final String OVERTIME_APPLY_PROCESS_FORM_TYPE = "overtime_apply";
  /**
   * 加班申请发起流程key
   */
  public static final String OVERTIME_APPLY_PROCESS_KEY = "overtime_apply_process001";
  /**
   * 加班申请发起流程名称
   */
  public static final String OVERTIME_APPLY_PROCESS_NAME = "加班审批流程";
}
