package com.biz.crm.sfa.business.overtime.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Set;

/**
 * 加班申请条件查询Dto
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OvertimeApplyConditionDto", description = "加班申请条件查询Dto")
public class OvertimeApplyConditionDto extends TenantDto {


  /***
   * 排除ID集合
   */
  @ApiModelProperty("排除ID集合")
  private List<String> excludeIds;

  /**
   * 排除的流程状态列表
   */
  @ApiModelProperty(value = "排除的流程状态列表")
  private List<String> excludeProcessStatusList;

  /**
   * 包含的流程状态列表
   */
  @ApiModelProperty(value = "包含的流程状态列表")
  private List<String> includeProcessStatusList;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 查询日期(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "查询日期(yyyy-MM-dd)")
  private String queryDate;

  /**
   * 人员账号
   */
  @ApiModelProperty(value = "人员账号")
  private String userName;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  private Set<String> ruleCodes;

  /**
   * 人员账号集合
   */
  @ApiModelProperty(value = "人员账号集合", hidden = true)
  private Set<String> userNames;


}
