package com.biz.crm.sfa.business.overtime.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.WorkflowFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 加班申请Dto
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OvertimeApplyDto", description = "加班申请Dto")
public class OvertimeApplyDto extends WorkflowFlagOpDto {

  /**
   * 申请原因
   */
  @ApiModelProperty(value = "申请原因")
  private String applyReason;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 日期时间明细
   */
  @ApiModelProperty(value = "日期时间明细")
  private List<OvertimeApplyTimeDto> timeList;

  /**
   * 申请时长(天)
   */
  @ApiModelProperty("申请时长(天)")
  private BigDecimal applyDuration;

  /**
   * 人员账号
   */
  @ApiModelProperty(value = "人员账号", hidden = true)
  private String userName;

  /**
   * 人员组织
   */
  @ApiModelProperty(value = "人员组织", hidden = true)
  private String orgCode;

  /**
   * 加班调整类型(normal普通调整，legal节假日调整)
   *
   * @see com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeType
   */
  @ApiModelProperty(value = "加班调整类型", hidden = true)
  private String overtimeType;

  /**
   * 考勤规则编码
   *
   */
  @ApiModelProperty(value = "考勤规则编码", hidden = true)
  private String ruleCode;


  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty(value = "申请日期(yyyy-MM-dd HH:mm:ss)", hidden = true)
  private String applyDate;

  /**
   * 节假日天数
   */
  @ApiModelProperty(value = "节假日天数", hidden = true)
  private BigDecimal holidayDays;

  /**
   * 申请编码
   */
  @ApiModelProperty(value = "申请编码", hidden = true)
  private String applyCode;

  /**
   * 人员姓名 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String realName;

  /**
   * 职位编码 职位编码
   */
  @ApiModelProperty("职位编码")
  private String posCode;

  /**
   * 职位名称 职位名称
   */
  @ApiModelProperty("职位名称")
  private String posName;

  /**
   * 所属组织名称 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 上级组织编码
   */
  @ApiModelProperty("上级组织编码")
  private String parentOrgCode;

  /**
   * 上级组织名称
   */
  @ApiModelProperty("上级组织名称")
  private String parentOrgName;
}
