package com.biz.crm.sfa.business.overtime.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 加班申请分页查询Dto
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OvertimeApplyPageDto", description = "加班申请分页查询Dto")
public class OvertimeApplyPageDto extends TenantDto {

  /**
   * 人员账号集合
   */
  @ApiModelProperty(value = "人员账号集合", hidden = true)
  private Set<String> userNames;

  /**
   * 关键字对应人员账号集合
   */
  @ApiModelProperty(value = "关键字对应人员账号集合", hidden = true)
  private Set<String> keyWordUserNames;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String keyWord;

  /**
   * 申请日期开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("申请日期开始 (yyyy-MM-dd)")
  private String applyDateStart;

  /**
   * 申请日期结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("申请日期结束 (yyyy-MM-dd)")
  private String applyDateEnd;

  /**
   * 加班开始时间开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("加班开始时间开始 (yyyy-MM-dd)")
  private String beginTimeStart;

  /**
   * 加班开始时间结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("加班开始时间结束 (yyyy-MM-dd)")
  private String beginTimeEnd;

  /**
   * 加班结束时间开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("加班结束时间开始 (yyyy-MM-dd)")
  private String endTimeStart;

  /**
   * 加班结束时间结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("加班结束时间结束 (yyyy-MM-dd)")
  private String endTimeEnd;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号")
  private String userName;

  /**
   * 用户姓名
   */
  @ApiModelProperty(value = "用户姓名")
  private String userRealName;

  /**
   * 职位名称
   */
  @ApiModelProperty(value = "职位名称")
  private String positionName;

  /**
   * 组织名称
   */
  @ApiModelProperty(value = "组织名称")
  private String orgName;

  /**
   * 上级组织名称
   */
  @ApiModelProperty(value = "上级组织名称")
  private String parentOrgName;
}
