package com.biz.crm.sfa.business.overtime.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 加班申请时间Dto
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Data
@ApiModel(value = "OvertimeApplyTimeDto", description = "加班申请时间Dto")
public class OvertimeApplyTimeDto {

  /**
   * 申请ID
   */
  @ApiModelProperty(value = "申请ID", hidden = true)
  private String applyId;

  /**
   * 明细时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "明细时间(yyyy-MM-dd)")
  private String itemTime;

  /**
   * 时间类型(all_day:全天;forenoon:上午;afternoon:下午)
   *
   * @see com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeTimeType
   */
  @ApiModelProperty(value = "时间类型(all_day:全天;forenoon:上午;afternoon:下午)")
  private String timeType;
}
