package com.biz.crm.sfa.business.overtime.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.math.BigDecimal;

/**
 * 加班时间类型枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum OvertimeTimeType {

  /**
   * 全天
   */
  ALL_DAY("all_day", "all_day", "全天", "1", BigDecimal.valueOf(1)),
  /**
   * 上午
   */
  FORENOON("forenoon", "forenoon", "上午", "2", BigDecimal.valueOf(0.5)),
  /**
   * 下午
   */
  AFTERNOON("afternoon", "afternoon", "下午", "3", BigDecimal.valueOf(0.5)),;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
  /**
   * 天数
   */
  private BigDecimal days;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static OvertimeTimeType getByDictCode(String dictCode) {
    OvertimeTimeType result = null;
    for (OvertimeTimeType type : OvertimeTimeType.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
