package com.biz.crm.sfa.business.overtime.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 加班类型枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum OvertimeType {

  /**
   * 普通加班
   */
  NORMAL("normal", "normal", "普通加班", "1"),
  /**
   * 节假日加班
   */
  HOLIDAY("holiday", "holiday", "节假日加班", "2")
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
