package com.biz.crm.sfa.business.overtime.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyConditionDto;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyPageDto;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyTimeVo;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 加班申请Vo服务接口
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
public interface OvertimeApplyVoService {

  /**
   * 通过ID集合查询加班申请信息
   *
   * @param ids ID集合
   * @return 加班申请信息
   */
  List<OvertimeApplyVo> findByIds(List<String> ids);

  /**
   * 通过审批状态查询加班申请信息
   *
   * @param processStatus
   * @return 加班申请信息
   */
  List<OvertimeApplyVo> findByProcessStatus(String processStatus);

  /**
   * 加班申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OvertimeApplyVo> 加班申请分页信息
   */
  Page<OvertimeApplyVo> findByConditions(Pageable pageable, OvertimeApplyPageDto dto);

  /**
   * 加班申请详情报表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OvertimeApplyVo> 加班申请分页信息
   */
  Page<OvertimeApplyVo> findDetailsByConditions(Pageable pageable, OvertimeApplyPageDto dto);


  /**
   * 加班天数集合
   *
   * @param dto      请求参数dto
   * @return List<OvertimeApplyTimeVo> 加班申请时间信息Vo
   */
  List<OvertimeApplyTimeVo> findOvertimeApplyTimeByConditions(OvertimeApplyConditionDto dto);
}
