package com.biz.crm.sfa.business.overtime.sdk.vo;

import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyTimeDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 加班申请信息Vo
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OvertimeApplyVo", description = "加班申请信息Vo")
public class OvertimeApplyVo extends WorkflowFlagOpVo {

  private static final long serialVersionUID = -7262877802300944536L;

  /**
   * 加班调整类型(normal普通调整，legal节假日调整)
   *
   * @see com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeType
   */
  @ApiModelProperty("加班调整类型")
  private String overtimeType;

  /**
   * 申请编码
   */
  @ApiModelProperty("申请编码")
  private String applyCode;

  /**
   * 申请原因
   */
  @ApiModelProperty( "申请原因")
  private String applyReason;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:ss)")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 申请时长(天)
   */
  @ApiModelProperty("申请时长(天)")
  private BigDecimal applyDuration;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String userName;

  /**
   * 人员名称
   */
  @ApiModelProperty("人员名称")
  private String userRealName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 审批通过时间(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("审批通过时间(yyyy-MM-dd HH:mm:ss)")
  private String auditPassDate;

  /**
   * 日期时间明细
   */
  @ApiModelProperty("日期时间明细")
  private List<OvertimeApplyTimeVo> timeList;

  /**
   * 节假日天数
   */
  @ApiModelProperty("节假日天数")
  private BigDecimal holidayDays;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String parentOrgName;
}
