package com.biz.crm.sfa.business.step.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.service.StepFormService;
import com.biz.crm.sfa.business.step.sdk.dto.StepFormPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 步骤表单配置表(StepForm)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-09 14:02:38
 */
@RestController
@RequestMapping("/v1/step/stepForm")
@Slf4j
@Api(tags = "步骤管理：StepForm：步骤表单配置表")
public class StepFormController {
  /**
   * 服务对象
   */
  @Autowired
  private StepFormService stepFormService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<StepForm>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                 @ApiParam(name = "dto", value = "条件dto") StepFormPageDto dto) {
    try {
      Page<StepForm> page = this.stepFormService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<StepForm> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      StepForm stepForm = this.stepFormService.findById(id);
      return Result.ok(stepForm);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param stepForm 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<StepForm> create(@ApiParam(name = "stepForm", value = "步骤表单配置表") @RequestBody StepForm stepForm) {
    try {
      StepForm result = this.stepFormService.create(stepForm);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param stepForm 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<StepForm> update(@ApiParam(name = "stepForm", value = "步骤表单配置表") @RequestBody StepForm stepForm) {
    try {
      StepForm result = this.stepFormService.update(stepForm);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.stepFormService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.stepFormService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.stepFormService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
