package com.biz.crm.sfa.business.step.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.step.sdk.service.StepRoleVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepRoleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 步骤角色配置表(stepRoleVo)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-13 13:59:33
 */
@RestController
@RequestMapping("/v1/step/stepRoleVo")
@Slf4j
@Api(tags = "步骤管理：StepRoleVo：步骤角色配置表")
public class StepRoleVoController {
  /**
   * 服务对象
   */
  @Autowired
  private StepRoleVoService stepRoleVoService;

  /**
   * 移动端-通过客户类型查看当前用户的执行步骤
   *
   * @param clientType 客户类型，对应字典client_type
   * @param visitType  拜访类型，对应字典visit_type
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByUserNameAndClientTypeAndVisitType")
  public Result<List<StepRoleVo>> findByUserNameAndClientTypeAndVisitType(@ApiParam(name = "clientType", value = "客户类型，对应字典client_type") @RequestParam(value = "clientType", required = false) String clientType,
                                                                          @ApiParam(name = "visitType", value = "拜访类型，对应字典visit_type") @RequestParam("visitType") String visitType,
                                                                          @ApiParam(name = "userName", value = "用户账号") @RequestParam("userName") String userName) {
    try {
      List<StepRoleVo> stepRoleVo = this.stepRoleVoService.findByUserNameAndClientTypeAndVisitType(userName, clientType, visitType);
      return Result.ok(stepRoleVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
