package com.biz.crm.sfa.business.step.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.DateTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 步骤表单配置表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StepForm", description = "步骤表单配置表")
@Entity
@TableName("sfa_step_form")
@Table(name = "sfa_step_form", indexes = {
    @Index(name = "sfa_step_form_index1", columnList = "step_code,tenant_code", unique = true),
    @Index(name = "sfa_step_form_index2", columnList = "step_name,tenant_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_step_form", comment = "步骤表单配置表")
public class StepForm extends TenantFlagOpEntity {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 步骤编码
   */
  @ApiModelProperty("步骤编码")
  @Column(name = "step_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '步骤编码'")
  private String stepCode;

  /**
   * 步骤名称
   */
  @ApiModelProperty("步骤名称")
  @Column(name = "step_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '步骤名称'")
  private String stepName;

  /**
   * 表单编码
   */
  @ApiModelProperty("表单编码")
  @Column(name = "form_code", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '表单编码'")
  private String formCode;

  /**
   * 表单名称
   */
  @ApiModelProperty("表单名称")
  @Column(name = "form_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '表单名称'")
  private String formName;

  /**
   * 拜访类型
   *
   * @see VisitTypeEnum#getDictCode()
   */
  @ApiModelProperty("拜访类型")
  @Column(name = "visit_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '拜访类型'")
  private String visitType;

  /**
   * 客户类型
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户细类
   * 取字典编码为经销商：customer_type、终端：terminal_type的数据
   */
  @ApiModelProperty("客户细类，取字典编码为customer_type或者terminal_type的数据")
  @Column(name = "client_sub_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户细类'")
  private String clientSubType;

  /**
   * 有效期类型
   *
   * @see DateTypeEnum#getDictCode()
   */
  @ApiModelProperty("有效期类型")
  @Column(name = "date_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '有效期类型'")
  private String dateType;

  /**
   * 有效期开始日期
   */
  @ApiModelProperty("有效期开始日期")
  @Column(name = "start_time", length = 32, columnDefinition = "date COMMENT '有效期开始日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date startTime;

  /**
   * 有效期结束日期
   */
  @ApiModelProperty("有效期结束日期")
  @Column(name = "end_time", length = 32, columnDefinition = "date COMMENT '有效期结束日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date endTime;

  /**
   * 是否获取定位信息
   */
  @ApiModelProperty("是否获取定位信息")
  @Column(name = "locate_type", length = 1, nullable = false, columnDefinition = "bit(1) COMMENT '是否获取定位信息: 1-是，0-否'")
  private Boolean locateType;

  /**
   * 距离限制（米）
   */
  @ApiModelProperty("距离限制（米）")
  @Column(name = "distance", length = 8, columnDefinition = "int(8) COMMENT '距离限制（米）'")
  private Integer distance;

  /**
   * logo集合
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("logo集合")
  private List<StepFormLogo> logos;
}
