package com.biz.crm.sfa.business.step.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 步骤角色配置表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StepRole", description = "步骤表单配置表")
@Entity
@TableName("sfa_step_role")
@Table(name = "sfa_step_role", indexes = {
    @Index(name = "sfa_step_role_index1", columnList = "role_code"),
    @Index(name = "sfa_step_role_index2", columnList = "visit_type"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_step_role", comment = "步骤角色配置表")
public class StepRole extends TenantFlagOpEntity {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  @Column(name = "role_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '角色编码'")
  private String roleCode;

  /**
   * 角色名称
   */
  @ApiModelProperty("角色名称")
  @Column(name = "role_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '角色名称'")
  private String roleName;

  /**
   * 拜访类型
   *
   * @see VisitTypeEnum#getDictCode()
   */
  @ApiModelProperty("拜访类型")
  @Column(name = "visit_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '拜访类型'")
  private String visitType;

  /**
   * 客户类型
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户细类
   * 取字典编码为经销商：customer_type、终端：terminal_type的数据
   */
  @ApiModelProperty("客户细类，取字典编码为customer_type或者terminal_type的数据")
  @Column(name = "client_sub_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户细类'")
  private String clientSubType;

  /**
   * 是否允许离线操作
   */
  @ApiModelProperty("是否允许离线操作")
  @Column(name = "off_line", length = 1, columnDefinition = "bit(1) COMMENT '是否允许离线操作，1-是，0-否'")
  private Boolean offLine = false;

  /**
   * 步骤角色表单关联集合
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("步骤角色表单关联集合")
  private List<StepRoleFormMapping> roleFormMappings;
}
