package com.biz.crm.sfa.business.step.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * 步骤角色表单关联表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StepRoleFormMapping", description = "步骤角色表单关联表")
@Entity
@TableName("sfa_step_role_form_mapping")
@Table(name = "sfa_step_role_form_mapping", indexes = {
    @Index(name = "sfa_step_role_form_mapping_index1", columnList = "step_role_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_step_role_form_mapping", comment = "步骤角色表单关联表")
public class StepRoleFormMapping extends UuidEntity {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 表单角色配置id
   */
  @ApiModelProperty("表单角色配置id")
  @Column(name = "step_role_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '表单角色配置id'")
  private String stepRoleId;

  /**
   * 步骤编码
   */
  @ApiModelProperty("步骤编码")
  @Column(name = "step_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '步骤编码'")
  private String stepCode;

  /**
   * 拜访顺序
   */
  @ApiModelProperty("拜访顺序")
  @Column(name = "sort_num", length = 4, nullable = false, columnDefinition = "int(4) COMMENT '拜访顺序'")
  private Integer sortNum;

  /**
   * 是否必做
   */
  @ApiModelProperty("是否必做")
  @Column(name = "do_not", length = 1, columnDefinition = "bit(64) COMMENT '是否必做,1-是，0-否'")
  private Boolean doNot = false;

  /**
   * 步骤名称（非数据库字典）
   */
  @ApiModelProperty("步骤名称")
  @Transient
  @TableField(exist = false)
  private String stepName;

  /**
   * 表单编码（非数据库字典）
   */
  @ApiModelProperty("表单编码")
  @Transient
  @TableField(exist = false)
  private String formCode;

}
