package com.biz.crm.sfa.business.step.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.step.local.entity.StepFormLogo;
import com.biz.crm.sfa.business.step.local.mapper.StepFormLogoMapper;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 步骤表单logo表(StepFormLogo)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-09 14:02:38
 */
@Component
public class StepFormLogoRepository extends ServiceImpl<StepFormLogoMapper, StepFormLogo> {

  /**
   * 根据步骤编码查询数据集合
   *
   * @param stepCode
   * @return
   */
  public List<StepFormLogo> findByStepCode(String stepCode) {
    return this.lambdaQuery().eq(StepFormLogo::getStepCode, stepCode).list();
  }

  /**
   * 根据步骤编码删除数据
   *
   * @param stepCode
   */
  public void deleteByStepCode(String stepCode) {
    this.lambdaUpdate().eq(StepFormLogo::getStepCode, stepCode).remove();
  }

  /**
   * 根据步骤编码查询数据集合
   *
   * @param stepCodes
   */
  public List<StepFormLogo> findByStepCodes(Set<String> stepCodes) {
    return this.lambdaQuery().in(StepFormLogo::getStepCode, stepCodes).list();
  }
}

