package com.biz.crm.sfa.business.step.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.step.local.entity.StepRoleFormMapping;
import com.biz.crm.sfa.business.step.local.mapper.StepRoleFormMappingMapper;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 步骤表单配置表(StepRoleFormMapping)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-13 13:59:34
 */
@Component
public class StepRoleFormMappingRepository extends ServiceImpl<StepRoleFormMappingMapper, StepRoleFormMapping> {

  /**
   * 根据步骤角色配置主键查询数据集合
   *
   * @param stepRoleId
   * @return
   */
  public List<StepRoleFormMapping> findByStepRoleId(String stepRoleId) {
    return this.baseMapper.findByStepRoleId(stepRoleId);
  }

  /**
   * 根据步骤角色配置主键删除数据
   *
   * @param stepRoleIds
   */
  public void deleteByStepRoleIds(List<String> stepRoleIds) {
    this.lambdaUpdate().in(StepRoleFormMapping::getStepRoleId, stepRoleIds).remove();
  }

  /**
   * 根据角色配置id查询关联信息
   *
   * @param roleIds
   * @return
   */
  public List<StepRoleFormMapping> findByStepRoleIds(List<String> roleIds) {
    return this.lambdaQuery().in(StepRoleFormMapping::getStepRoleId, roleIds).list();
  }

  /**
   * 根据步骤编码集合查询数据
   *
   * @param stepCodes
   * @return
   */
  public List<StepRoleFormMapping> findByStepCodes(Set<String> stepCodes) {
    return this.lambdaQuery().in(StepRoleFormMapping::getStepCode, stepCodes).list();
  }
}

