package com.biz.crm.sfa.business.step.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.step.local.entity.StepRole;
import com.biz.crm.sfa.business.step.sdk.dto.StepRoleDataDto;
import com.biz.crm.sfa.business.step.sdk.dto.StepRolePageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 步骤角色配置表(StepRole)表服务接口
 *
 * @author songjingen
 * @since 2022-06-13 13:59:33
 */
public interface StepRoleService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  Page<StepRole> findByConditions(Pageable pageable, StepRolePageDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  StepRole findById(String id);

  /**
   * 新增数据
   *
   * @param stepRoleDataDto 实体对象
   * @return 新增结果
   */
  void create(StepRoleDataDto stepRoleDataDto);

  /**
   * 修改新据
   *
   * @param dto 实体对象
   * @return 修改结果
   */
  StepRole update(StepRoleDataDto dto);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

}

