package com.biz.crm.sfa.business.step.local.service.internal;


import com.biz.crm.sfa.business.step.local.entity.StepFormLogo;
import com.biz.crm.sfa.business.step.local.repository.StepFormLogoRepository;
import com.biz.crm.sfa.business.step.local.service.StepFormLogoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 步骤表单logo表(StepFormLogo)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-09 14:02:38
 */
@Service("stepFormLogoService")
public class StepFormLogoServiceImpl implements StepFormLogoService {

  @Autowired
  private StepFormLogoRepository stepFormLogoRepository;


  @Override
  public List<StepFormLogo> findByStepCode(String stepCode) {
    if (StringUtils.isBlank(stepCode)) {
      return new ArrayList<>(0);
    }
    return this.stepFormLogoRepository.findByStepCode(stepCode);
  }

  @Transactional
  @Override
  public void createBatch(List<StepFormLogo> logos) {
    Validate.isTrue(!CollectionUtils.isEmpty(logos), "新增logo时，入参不能为空！");
    logos.stream().forEach(stepFormLogo -> stepFormLogo.setTenantCode(TenantUtils.getTenantCode()));
    this.stepFormLogoRepository.saveBatch(logos);
  }

  @Transactional
  @Override
  public void deleteByStepCode(String stepCode) {
    this.stepFormLogoRepository.deleteByStepCode(stepCode);
  }
}

