package com.biz.crm.sfa.business.step.local.service.internal;

import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.entity.StepFormLogo;
import com.biz.crm.sfa.business.step.local.repository.StepFormLogoRepository;
import com.biz.crm.sfa.business.step.local.repository.StepFormRepository;
import com.biz.crm.sfa.business.step.sdk.service.StepFormVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormLogoVo;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * StepFormVo服务实现类
 *
 * @author songjingen
 * @date 2022/6/27
 */
@Service
public class StepFormVoServiceImpl implements StepFormVoService {

  @Autowired
  private StepFormRepository stepFormRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private StepFormLogoRepository stepFormLogoRepository;

  @Override
  public List<StepFormVo> findByStepCodes(Set<String> stepCodes) {
    if (CollectionUtils.isEmpty(stepCodes)) {
      return new ArrayList<>(0);
    }
    List<StepForm> byStepCodes = this.stepFormRepository.findByStepCodes(stepCodes);
    if (CollectionUtils.isEmpty(byStepCodes)) {
      return new ArrayList<>(0);
    }
    List<StepFormVo> list = (List<StepFormVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byStepCodes, StepForm.class, StepFormVo.class, HashSet.class, ArrayList.class);
    //查询步骤logo信息并且转成map
    List<StepFormLogo> stepFormLogos = this.stepFormLogoRepository.findByStepCodes(stepCodes);
    Map<String, List<StepFormLogoVo>> stringStepFormLogoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(stepFormLogos)) {
      List<StepFormLogoVo> stepFormLogoVos = (List<StepFormLogoVo>) this.nebulaToolkitService.copyCollectionByWhiteList(stepFormLogos, StepFormLogo.class, StepFormLogoVo.class, HashSet.class, ArrayList.class);
      stringStepFormLogoHashMap = stepFormLogoVos.stream().collect(Collectors.groupingBy(StepFormLogoVo::getStepCode));
    }
    for (StepFormVo stepFormVo : list) {
      stepFormVo.setLogos(stringStepFormLogoHashMap.get(stepFormVo.getStepCode()));
    }
    return list;
  }
}
