package com.biz.crm.sfa.business.step.local.service.internal;


import com.biz.crm.sfa.business.step.local.entity.StepRoleFormMapping;
import com.biz.crm.sfa.business.step.local.repository.StepRoleFormMappingRepository;
import com.biz.crm.sfa.business.step.local.service.StepRoleFormMappingService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 步骤表单配置表(StepRoleFormMapping)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-13 13:59:33
 */
@Service("stepRoleFormMappingService")
public class StepRoleFormMappingServiceImpl implements StepRoleFormMappingService {

  @Autowired
  private StepRoleFormMappingRepository stepRoleFormMappingRepository;

  @Override
  public List<StepRoleFormMapping> findByStepRoleId(String stepRoleId) {
    if (StringUtils.isBlank(stepRoleId)) {
      return new ArrayList<>(0);
    }
    return this.stepRoleFormMappingRepository.findByStepRoleId(stepRoleId);
  }

  @Transactional
  @Override
  public void createBatch(List<StepRoleFormMapping> formMappings) {
    Validate.isTrue(!CollectionUtils.isEmpty(formMappings), "批量新增数据时，入参集合不能为空！");
    formMappings.forEach(this::createValidate);
    this.stepRoleFormMappingRepository.saveBatch(formMappings);
  }

  @Transactional
  @Override
  public void deleteByStepRoleIds(List<String> stepRoleIds) {
    this.stepRoleFormMappingRepository.deleteByStepRoleIds(stepRoleIds);
  }


  /**
   * 创建验证
   *
   * @param stepRoleFormMapping
   */
  private void createValidate(StepRoleFormMapping stepRoleFormMapping) {
    Validate.notNull(stepRoleFormMapping, "新增时，对象信息不能为空！");
    stepRoleFormMapping.setId(null);
    Validate.notNull(stepRoleFormMapping.getSortNum(), "新增数据时，拜访顺序不能为空！");
    Validate.notBlank(stepRoleFormMapping.getStepCode(), "新增数据时，步骤编码不能为空！");

  }
}

