package com.biz.crm.sfa.business.step.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.entity.StepFormLogo;
import com.biz.crm.sfa.business.step.local.entity.StepRole;
import com.biz.crm.sfa.business.step.local.entity.StepRoleFormMapping;
import com.biz.crm.sfa.business.step.local.repository.StepFormLogoRepository;
import com.biz.crm.sfa.business.step.local.repository.StepFormRepository;
import com.biz.crm.sfa.business.step.local.repository.StepRoleFormMappingRepository;
import com.biz.crm.sfa.business.step.local.repository.StepRoleRepository;
import com.biz.crm.sfa.business.step.sdk.service.StepRoleVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormLogoVo;
import com.biz.crm.sfa.business.step.sdk.vo.StepRoleFormMappingVo;
import com.biz.crm.sfa.business.step.sdk.vo.StepRoleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum.STRANGE;

/**
 * 步骤角色配置表(StepRoleVo)表服务实现类
 *
 * @author songjingen
 * @date 2022/6/16
 */
@Service
public class StepRoleVoServiceImpl implements StepRoleVoService {

  @Autowired
  private StepFormRepository stepFormRepository;
  @Autowired
  private StepFormLogoRepository stepFormLogoRepository;
  @Autowired
  private StepRoleRepository stepRoleRepository;
  @Autowired
  private StepRoleFormMappingRepository stepRoleFormMappingRepository;
  @Autowired(required = false)
  private PositionVoService positionVoService;
  @Autowired(required = false)
  private UserVoService userVoService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public List<StepRoleVo> findByUserNameAndClientTypeAndVisitType(String userName, String clientType, String visitType) {
    if (StringUtils.isAnyBlank(userName, visitType)) {
      return null;
    }
    //获取角色
    List<String> roles = this.findRoleCodesByUserName(userName);
    List<StepRole> stepRoles = new ArrayList<>();
    if (STRANGE.getDictCode().equals(visitType)) {
      stepRoles = this.stepRoleRepository.findByVisitTypeAndRoleCodes(visitType, roles);
    } else {
      stepRoles = this.stepRoleRepository.findByVisitTypeAndClientTypeAndRoleCodes(visitType, clientType, roles);
    }
    if (CollectionUtils.isEmpty(stepRoles)) {
      return null;
    }
    //获取角色关联步骤
    List<String> roleIds = stepRoles.stream().map(StepRole::getId).collect(Collectors.toList());
    List<StepRoleFormMapping> roleFormMappings = this.stepRoleFormMappingRepository.findByStepRoleIds(roleIds);
    if (CollectionUtils.isEmpty(roleFormMappings)) {
      return null;
    }
    List<StepRoleFormMappingVo> stepRoleFormMappingVos = (List<StepRoleFormMappingVo>) this.nebulaToolkitService.copyCollectionByWhiteList(roleFormMappings, StepRoleFormMapping.class, StepRoleFormMappingVo.class, HashSet.class, ArrayList.class);
    Map<String, List<StepRoleFormMappingVo>> stringListMap = stepRoleFormMappingVos.stream()
        .sorted(Comparator.comparingLong(StepRoleFormMappingVo::getSortNum))
        .collect(Collectors.groupingBy(StepRoleFormMappingVo::getStepRoleId));
    Set<String> stepCodes = roleFormMappings.stream().map(StepRoleFormMapping::getStepCode).collect(Collectors.toSet());
    //查询步骤信息并且转成map
    List<StepForm> stepForms = this.stepFormRepository.findByStepCodes(stepCodes);
    if (CollectionUtils.isEmpty(stepForms)) {
      return null;
    }
    Map<String, StepForm> stringStepFormHashMap = stepForms.stream().collect(Collectors.toMap(StepForm::getStepCode, o -> o));
    //查询步骤logo信息并且转成map
    List<StepFormLogo> stepFormLogos = this.stepFormLogoRepository.findByStepCodes(stepCodes);
    Map<String, List<StepFormLogoVo>> stringStepFormLogoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(stepFormLogos)) {
      List<StepFormLogoVo> stepFormLogoVos = (List<StepFormLogoVo>) this.nebulaToolkitService.copyCollectionByWhiteList(stepFormLogos, StepFormLogo.class, StepFormLogoVo.class, HashSet.class, ArrayList.class);
      stringStepFormLogoHashMap = stepFormLogoVos.stream().collect(Collectors.groupingBy(StepFormLogoVo::getStepCode));
    }
    //组装数据
    List<StepRoleVo> stepRoleVos = (List<StepRoleVo>) this.nebulaToolkitService.copyCollectionByWhiteList(stepRoles, StepRole.class, StepRoleVo.class, HashSet.class, ArrayList.class);
    for (StepRoleVo vo : stepRoleVos) {
      List<StepRoleFormMappingVo> roleFormMappingVos = stringListMap.get(vo.getId());
      if (!CollectionUtils.isEmpty(roleFormMappingVos)) {
        for (StepRoleFormMappingVo roleFormMappingVo : roleFormMappingVos) {
          StepForm stepForm = stringStepFormHashMap.get(roleFormMappingVo.getStepCode());
          if (stepForm != null) {
            BeanUtils.copyProperties(stepForm, roleFormMappingVo);
          }
          List<StepFormLogoVo> formLogos = stringStepFormLogoHashMap.get(roleFormMappingVo.getStepCode());
          if (!CollectionUtils.isEmpty(formLogos)) {
            roleFormMappingVo.setLogos(formLogos);
          }
        }
        vo.setRoleFormMappings(roleFormMappingVos);
      }
    }
    return stepRoleVos;
  }

  /**
   * 根据用户账号获取角色信息
   *
   * @return
   */
  private List<String> findRoleCodesByUserName(String userName) {
    //根据用户账号查询角色
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    String account = loginDetails.getAccount();
    List<String> roles = new ArrayList<>();
    if (account.equals(userName)) {
      roles = loginDetails.getRoles();
    } else {
      Set<String> positionCodes = this.userVoService.findPositionCodesByUserNames(Lists.newArrayList(userName));
      if (CollectionUtils.isEmpty(positionCodes)) {
        return null;
      }
      Set<String> rolesByPositionCodes = this.positionVoService.findRolesByPositionCodes(Lists.newArrayList(positionCodes));
      roles = Lists.newArrayList(rolesByPositionCodes);
    }
    return roles;

  }
}
