/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.step.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.mapper.StepFormMapper;
import com.biz.crm.sfa.business.step.sdk.dto.StepFormPageDto;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class StepFormRepository
extends ServiceImpl<StepFormMapper, StepForm> {
    @Autowired
    private StepFormMapper stepFormMapper;

    public Page<StepForm> findByConditions(Pageable pageable, StepFormPageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<StepForm> pageList = this.stepFormMapper.findByConditions((Page<StepForm>)page, dto);
        return pageList;
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> idList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, idList)).update();
    }

    public List<StepForm> findByStepCodes(Set<String> stepCodes) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(StepForm::getStepCode, stepCodes)).list();
    }

    public List<StepForm> findByIds(List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, idList)).list();
    }

    public List<StepForm> findByStepName(String stepName) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(StepForm::getStepName, (Object)stepName)).list();
    }
}

