/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.step.local.service.internal;

import com.biz.crm.sfa.business.step.local.entity.StepFormLogo;
import com.biz.crm.sfa.business.step.local.repository.StepFormLogoRepository;
import com.biz.crm.sfa.business.step.local.service.StepFormLogoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="stepFormLogoService")
public class StepFormLogoServiceImpl
implements StepFormLogoService {
    @Autowired
    private StepFormLogoRepository stepFormLogoRepository;

    @Override
    public List<StepFormLogo> findByStepCode(String stepCode) {
        if (StringUtils.isBlank((CharSequence)stepCode)) {
            return new ArrayList<StepFormLogo>(0);
        }
        return this.stepFormLogoRepository.findByStepCode(stepCode);
    }

    @Override
    @Transactional
    public void createBatch(List<StepFormLogo> logos) {
        Validate.isTrue((!CollectionUtils.isEmpty(logos) ? 1 : 0) != 0, (String)"\u65b0\u589elogo\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        logos.stream().forEach(stepFormLogo -> stepFormLogo.setTenantCode(TenantUtils.getTenantCode()));
        this.stepFormLogoRepository.saveBatch(logos);
    }

    @Override
    @Transactional
    public void deleteByStepCode(String stepCode) {
        this.stepFormLogoRepository.deleteByStepCode(stepCode);
    }
}

