/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.step.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.entity.StepFormLogo;
import com.biz.crm.sfa.business.step.local.repository.StepFormRepository;
import com.biz.crm.sfa.business.step.local.service.StepFormLogoService;
import com.biz.crm.sfa.business.step.local.service.StepFormService;
import com.biz.crm.sfa.business.step.sdk.dto.StepFormPageDto;
import com.biz.crm.sfa.business.step.sdk.enums.DateTypeEnum;
import com.biz.crm.sfa.business.step.sdk.strategy.StepFormValidationStrategy;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="stepFormService")
public class StepFormServiceImpl
implements StepFormService {
    @Autowired
    private StepFormRepository stepFormRepository;
    @Autowired
    private StepFormLogoService stepFormLogoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private List<StepFormValidationStrategy> stepFormValidationStrategies;

    @Override
    public Page<StepForm> findByConditions(Pageable pageable, StepFormPageDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new StepFormPageDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<StepForm> byConditions = this.stepFormRepository.findByConditions(pageable, dto);
        List records = byConditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        this.buildStepForm(records);
        return byConditions;
    }

    @Override
    public StepForm findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        StepForm stepForm = (StepForm)((Object)this.stepFormRepository.getById((Serializable)((Object)id)));
        if (stepForm == null) {
            return null;
        }
        List<StepFormLogo> stepFormLogos = this.stepFormLogoService.findByStepCode(stepForm.getStepCode());
        stepForm.setLogos(stepFormLogos);
        this.buildStepForm(Lists.newArrayList((Object[])new StepForm[]{stepForm}));
        return stepForm;
    }

    @Override
    @Transactional
    public StepForm create(StepForm stepForm) {
        this.createValidate(stepForm);
        this.stepFormRepository.saveOrUpdate((Object)stepForm);
        List<StepFormLogo> logos = stepForm.getLogos();
        Validate.isTrue((!CollectionUtils.isEmpty(logos) ? 1 : 0) != 0, (String)"\u65b0\u589elogo\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        logos.stream().forEach(stepFormLogo -> stepFormLogo.setStepCode(stepForm.getStepCode()));
        this.stepFormLogoService.createBatch(logos);
        return stepForm;
    }

    @Override
    @Transactional
    public StepForm update(StepForm stepForm) {
        StepForm form = (StepForm)((Object)this.stepFormRepository.getById((Serializable)((Object)stepForm.getId())));
        Validate.notNull((Object)((Object)form), (String)"\u7f16\u8f91\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u7f16\u8f91\u7684\u4fe1\u606f\uff01", (Object[])new Object[0]);
        if (!form.getStepName().equals(stepForm.getStepName())) {
            List<StepForm> stepForms = this.stepFormRepository.findByStepName(stepForm.getStepName());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(stepForms), (String)"\u7f16\u8f91\u65f6\uff0c\u6b65\u9aa4\u540d\u79f0\u91cd\u590d\uff01", (Object[])new Object[0]);
        }
        BeanUtils.copyProperties((Object)((Object)stepForm), (Object)((Object)form), (String[])new String[]{"id", "stepCode", "tenantCode", "delFlag", "enableStatus", "createAccount", "createTime", "createName"});
        this.updateValidate(form);
        this.stepFormRepository.saveOrUpdate((Object)form);
        List<StepFormLogo> logos = stepForm.getLogos();
        Validate.isTrue((!CollectionUtils.isEmpty(logos) ? 1 : 0) != 0, (String)"\u65b0\u589elogo\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        logos.stream().forEach(stepFormLogo -> stepFormLogo.setStepCode(form.getStepCode()));
        this.stepFormLogoService.deleteByStepCode(form.getStepCode());
        this.stepFormLogoService.createBatch(logos);
        return form;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stepFormValidate(idList);
        this.stepFormRepository.updateDelFlagByIds(idList);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stepFormRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stepFormValidate(idList);
        this.stepFormRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    private void buildStepForm(List<StepForm> stepForms) {
        Map<Object, Object> terminalTypeMap = new HashMap();
        Map<Object, Object> dealerTypeMap = new HashMap();
        ArrayList list = Lists.newArrayList();
        list.add("terminal_type");
        list.add("customer_type");
        Map dictTypeCodeList = this.dictDataVoService.findByDictTypeCodeList((List)list);
        if (dictTypeCodeList != null) {
            List dealerDicts;
            List terminalDicts = (List)dictTypeCodeList.get("terminal_type");
            if (!CollectionUtils.isEmpty((Collection)terminalDicts)) {
                terminalTypeMap = terminalDicts.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
            }
            if (!CollectionUtils.isEmpty((Collection)(dealerDicts = (List)dictTypeCodeList.get("customer_type")))) {
                dealerTypeMap = dealerDicts.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
            }
        }
        for (StepForm stepForm : stepForms) {
            String clientType = stepForm.getClientType();
            String clientSubType = stepForm.getClientSubType();
            if (ClientTypeEnum.TERMINAL.getDictCode().equals(clientType)) {
                stepForm.setClientSubType((String)terminalTypeMap.get(clientSubType));
            }
            if (!ClientTypeEnum.DEALER.getDictCode().equals(clientType)) continue;
            stepForm.setClientSubType((String)dealerTypeMap.get(clientSubType));
        }
    }

    private void createValidate(StepForm stepForm) {
        Validate.notNull((Object)((Object)stepForm), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        stepForm.setId(null);
        stepForm.setTenantCode(TenantUtils.getTenantCode());
        stepForm.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        stepForm.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        stepForm.setStepCode((String)this.generateCodeService.generateCode("BZ", 1).get(0));
        Validate.notBlank((CharSequence)stepForm.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getFormCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getFormName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8868\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getStepCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getStepName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getClientType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getDateType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (DateTypeEnum.DEFINITION.getDictCode().equals(stepForm.getDateType())) {
            Validate.notNull((Object)stepForm.getStartTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)stepForm.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((stepForm.getStartTime().compareTo(stepForm.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5728\u7ed3\u675f\u65e5\u671f\u4e4b\u540e\uff01", (Object[])new Object[0]);
        }
        Validate.notNull((Object)stepForm.getLocateType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u83b7\u53d6\u5b9a\u4f4d\u4fe1\u606f: 1-\u662f\uff0c0-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (stepForm.getLocateType().booleanValue()) {
            Validate.notNull((Object)stepForm.getDistance(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ddd\u79bb\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<StepForm> stepForms = this.stepFormRepository.findByStepName(stepForm.getStepName());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(stepForms), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u540d\u79f0\u91cd\u590d\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(StepForm stepForm) {
        Validate.notNull((Object)((Object)stepForm), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getFormCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getFormName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8868\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getStepCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getStepName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getClientType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepForm.getDateType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (DateTypeEnum.DEFINITION.getDictCode().equals(stepForm.getDateType())) {
            Validate.notNull((Object)stepForm.getStartTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)stepForm.getEndTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((stepForm.getStartTime().compareTo(stepForm.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5728\u7ed3\u675f\u65e5\u671f\u4e4b\u540e\uff01", (Object[])new Object[0]);
        }
        Validate.notNull((Object)stepForm.getLocateType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u662f\u5426\u83b7\u53d6\u5b9a\u4f4d\u4fe1\u606f: 1-\u662f\uff0c0-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (stepForm.getLocateType().booleanValue()) {
            Validate.notNull((Object)stepForm.getDistance(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8ddd\u79bb\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    private void stepFormValidate(List<String> idList) {
        List<StepForm> stepForms = this.stepFormRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u64cd\u4f5c\u7684\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Set stepCodes = stepForms.stream().map(StepForm::getStepCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(this.stepFormValidationStrategies)) {
            for (StepFormValidationStrategy stepFormValidationStrategy : this.stepFormValidationStrategies) {
                stepFormValidationStrategy.stepCodeUsedValidate(stepCodes);
            }
        }
    }
}

