/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.step.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.entity.StepRole;
import com.biz.crm.sfa.business.step.local.entity.StepRoleFormMapping;
import com.biz.crm.sfa.business.step.local.repository.StepFormRepository;
import com.biz.crm.sfa.business.step.local.repository.StepRoleRepository;
import com.biz.crm.sfa.business.step.local.service.StepRoleFormMappingService;
import com.biz.crm.sfa.business.step.local.service.StepRoleService;
import com.biz.crm.sfa.business.step.sdk.dto.StepRoleDataDto;
import com.biz.crm.sfa.business.step.sdk.dto.StepRolePageDto;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.register.NecessaryFormRegister;
import com.biz.crm.sfa.business.step.sdk.strategy.ExecutePlanCallBackStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="stepRoleService")
public class StepRoleServiceImpl
implements StepRoleService {
    @Autowired
    private StepRoleRepository stepRoleRepository;
    @Autowired
    private StepRoleFormMappingService stepRoleFormMappingService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private List<NecessaryFormRegister> necessaryFormRegisters;
    @Autowired
    private StepFormRepository stepFormRepository;
    @Autowired(required=false)
    private List<ExecutePlanCallBackStrategy> executePlanCallBackStrategies;
    @Autowired(required=false)
    private UserVoService userVoService;
    @Autowired(required=false)
    private PositionVoService positionVoService;

    @Override
    public Page<StepRole> findByConditions(Pageable pageable, StepRolePageDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new StepRolePageDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<StepRole> byConditions = this.stepRoleRepository.findByConditions(pageable, dto);
        List records = byConditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        this.buildStepRole(records);
        return byConditions;
    }

    @Override
    public StepRole findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        StepRole stepRole = (StepRole)((Object)this.stepRoleRepository.getById((Serializable)((Object)id)));
        if (stepRole == null) {
            return null;
        }
        List<StepRoleFormMapping> stepRoleFormMappings = this.stepRoleFormMappingService.findByStepRoleId(id);
        stepRole.setRoleFormMappings(stepRoleFormMappings);
        this.buildStepRole(Lists.newArrayList((Object[])new StepRole[]{stepRole}));
        return stepRole;
    }

    @Override
    @Transactional
    public void create(StepRoleDataDto stepRoleDataDto) {
        this.createRoleDataValidate(stepRoleDataDto);
        List stepFormData = stepRoleDataDto.getStepFormData();
        List stepRoleFormMappings = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)stepFormData, StepRoleDataDto.StepFormData.class, StepRoleFormMapping.class, HashSet.class, ArrayList.class, new String[0]);
        this.stepRoleFormMappingsValidate(stepRoleFormMappings);
        ArrayList<StepRole> stepRoles = new ArrayList<StepRole>();
        for (StepRoleDataDto.RoleData roleDatum : stepRoleDataDto.getRoleData()) {
            StepRole stepRole2 = (StepRole)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)stepRoleDataDto, StepRole.class, HashSet.class, ArrayList.class, new String[0]));
            stepRole2.setRoleCode(roleDatum.getRoleCode());
            stepRole2.setRoleName(roleDatum.getRoleName());
            this.createValidate(stepRole2);
            stepRoles.add(stepRole2);
        }
        this.stepRoleRepository.saveBatch(stepRoles);
        ArrayList<StepRoleFormMapping> formMappings = new ArrayList<StepRoleFormMapping>();
        stepRoles.stream().forEach(stepRole -> {
            String stepRoleId = stepRole.getId();
            for (StepRoleFormMapping stepRoleFormMapping : stepRoleFormMappings) {
                StepRoleFormMapping mapping = new StepRoleFormMapping();
                BeanUtils.copyProperties((Object)((Object)stepRoleFormMapping), (Object)((Object)mapping));
                mapping.setStepRoleId(stepRoleId);
                formMappings.add(mapping);
            }
        });
        this.stepRoleFormMappingService.createBatch(formMappings);
    }

    @Override
    @Transactional
    public StepRole update(StepRoleDataDto stepRoleDataDto) {
        Validate.notNull((Object)stepRoleDataDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRoleDataDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List stepFormData = stepRoleDataDto.getStepFormData();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)stepFormData) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5173\u8054\u6b65\u9aa4\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List roleFormMappings = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)stepFormData, StepRoleDataDto.StepFormData.class, StepRoleFormMapping.class, HashSet.class, ArrayList.class, new String[0]);
        this.stepRoleFormMappingsValidate(roleFormMappings);
        StepRole role = (StepRole)((Object)this.stepRoleRepository.getById((Serializable)((Object)stepRoleDataDto.getId())));
        Validate.notNull((Object)((Object)role), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u4fee\u6539\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        role.setOffLine(stepRoleDataDto.getOffLine());
        this.updateValidate(role);
        this.stepRoleRepository.saveOrUpdate((Object)role);
        this.stepRoleFormMappingService.deleteByStepRoleIds(Lists.newArrayList((Object[])new String[]{role.getId()}));
        roleFormMappings.stream().forEach(stepRoleFormMapping -> stepRoleFormMapping.setStepRoleId(role.getId()));
        this.stepRoleFormMappingService.createBatch(roleFormMappings);
        return role;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<StepRole> stepRoles = this.stepRoleRepository.findByIds(new HashSet<String>(idList));
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        List enableStepRoles = stepRoles.stream().filter(stepRole -> EnableStatusEnum.ENABLE.getCode().equals(stepRole.getEnableStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(enableStepRoles), (String)"\u5b58\u5728\u672a\u7981\u7528\u7684\u6570\u636e\uff0c\u8bf7\u7981\u7528\u540e\u518d\u6b21\u5220\u9664\uff01\uff01", (Object[])new Object[0]);
        this.stepRoleRepository.updateDelFlagByIds(idList, DelFlagStatusEnum.DELETE);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stepRoleRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<StepRole> stepRoles = this.stepRoleRepository.findByIds(new HashSet<String>(idList));
        Validate.isTrue((!CollectionUtils.isEmpty(stepRoles) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        Set<String> visitTypes = stepRoles.stream().map(StepRole::getVisitType).collect(Collectors.toSet());
        Set<String> roles = this.findRoleCodesByVisitTypes(visitTypes);
        if (!CollectionUtils.isEmpty(roles)) {
            Set disableRoles = stepRoles.stream().map(StepRole::getRoleCode).collect(Collectors.toSet());
            disableRoles.retainAll(roles);
            if (!CollectionUtils.isEmpty(disableRoles)) {
                throw new RuntimeException("\u89d2\u8272\u7f16\u7801" + disableRoles.toString() + "\u5f53\u524d\u5b58\u5728\u6267\u884c\u4e2d\u7684\u8ba1\u5212\uff0c\u4e0d\u80fd\u7981\u7528\uff01");
            }
        }
        this.stepRoleRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    private void createValidate(StepRole stepRole) {
        Validate.notNull((Object)((Object)stepRole), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        stepRole.setId(null);
        stepRole.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        stepRole.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        stepRole.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)stepRole.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getClientType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getRoleCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getVisitType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(StepRole stepRole) {
        Validate.notNull((Object)((Object)stepRole), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getClientType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getRoleCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stepRole.getVisitType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createRoleDataValidate(StepRoleDataDto stepRoleDataDto) {
        Validate.notNull((Object)stepRoleDataDto, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5165\u53c2\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List roleData = stepRoleDataDto.getRoleData();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)roleData) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u89d2\u8272\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)stepRoleDataDto.getStepFormData()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u8868\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<String> roleCodes = roleData.stream().map(v -> {
            if (StringUtils.isBlank((CharSequence)v.getRoleCode())) {
                throw new RuntimeException("\u63d0\u4ea4\u4e86\u7a7a\u503c\u89d2\u8272\u7f16\u7801");
            }
            return v.getRoleCode();
        }).collect(Collectors.toList());
        String visitType = stepRoleDataDto.getVisitType();
        String clientType = stepRoleDataDto.getClientType();
        List<Object> list = new ArrayList();
        list = VisitTypeEnum.STRANGE.getDictCode().equals(visitType) ? this.stepRoleRepository.findByVisitTypeAndRoleCodes(visitType, roleCodes) : this.stepRoleRepository.findByVisitTypeAndClientTypeAndRoleCodes(visitType, clientType, roleCodes);
        Map<String, StepRole> roleMapConfig = list.stream().collect(Collectors.toMap(StepRole::getRoleCode, v -> v, (t, t2) -> t2));
        for (StepRoleDataDto.RoleData role : roleData) {
            if (!roleMapConfig.containsKey(role.getRoleCode())) continue;
            throw new RuntimeException("\u89d2\u8272[" + role.getRoleName() + "]\u5df2\u5b58\u5728[" + VisitTypeEnum.getByDictCode((String)visitType).getValue() + "]\u6b65\u9aa4\u914d\u7f6e,\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e");
        }
    }

    private void stepRoleFormMappingsValidate(List<StepRoleFormMapping> stepRoleFormMappings) {
        Set<String> stepCodes = stepRoleFormMappings.stream().map(StepRoleFormMapping::getStepCode).collect(Collectors.toSet());
        Validate.isTrue((stepCodes.size() == stepRoleFormMappings.size() ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u9009\u62e9\u7684\u62dc\u8bbf\u6b65\u9aa4\u4e2d\u5b58\u5728\u91cd\u590d\u6b65\u9aa4!", (Object[])new Object[0]);
        List<StepForm> stepForms = this.stepFormRepository.findByStepCodes(stepCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(stepForms) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u6b65\u9aa4\u5173\u8054\u7684\u6b65\u9aa4\u8868\u5355\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Map<String, String> stepFormMap = stepForms.stream().collect(Collectors.toMap(StepForm::getStepCode, o -> o.getFormCode()));
        HashMap<String, StepRoleFormMapping> stepRoleFormMappingMap = new HashMap<String, StepRoleFormMapping>();
        for (StepRoleFormMapping stepRoleFormMapping : stepRoleFormMappings) {
            String formCode = stepFormMap.get(stepRoleFormMapping.getStepCode());
            if (!StringUtils.isNotBlank((CharSequence)formCode)) continue;
            stepRoleFormMapping.setFormCode(formCode);
            stepRoleFormMappingMap.put(formCode, stepRoleFormMapping);
        }
        if (!CollectionUtils.isEmpty(this.necessaryFormRegisters)) {
            for (NecessaryFormRegister necessaryFormRegister : this.necessaryFormRegisters) {
                StepRoleFormMapping stepRoleFormMapping = (StepRoleFormMapping)((Object)stepRoleFormMappingMap.get(necessaryFormRegister.dynamicFormCode()));
                Validate.notNull((Object)((Object)stepRoleFormMapping), (String)"\u914d\u7f6e\u6b65\u9aa4\u65f6\uff0c\u7cfb\u7edf\u9884\u8bbe\u7684\u8868\u5355\u3010%s\u3011\u5fc5\u987b\u5b58\u5728\uff01", (Object[])new Object[]{necessaryFormRegister.dynamicFormName()});
            }
            NecessaryFormRegister firstNecessaryFormRegister = (NecessaryFormRegister)this.necessaryFormRegisters.stream().filter(NecessaryFormRegister::first).sorted().collect(Collectors.toList()).get(0);
            NecessaryFormRegister lastNecessaryFormRegister = (NecessaryFormRegister)this.necessaryFormRegisters.stream().filter(NecessaryFormRegister::last).sorted().collect(Collectors.toList()).get(0);
            int firstCount = 0;
            int lastCount = 0;
            Integer lastSortNum = ((StepRoleFormMapping)((Object)stepRoleFormMappings.stream().sorted(Comparator.comparing(StepRoleFormMapping::getSortNum).reversed()).collect(Collectors.toList()).get(0))).getSortNum();
            for (StepRoleFormMapping stepRoleFormMapping : stepRoleFormMappings) {
                Integer sortNum = stepRoleFormMapping.getSortNum();
                Boolean doNot = stepRoleFormMapping.getDoNot();
                if (firstNecessaryFormRegister != null && StringUtils.equals((CharSequence)stepRoleFormMapping.getFormCode(), (CharSequence)firstNecessaryFormRegister.dynamicFormCode())) {
                    Validate.isTrue((sortNum == 1 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f53\u524d\u8868\u5355\u3010%s\u3011\u7684\u6b65\u9aa4\u3010%s\u3011\u7684\u62dc\u8bbf\u987a\u5e8f\u5fc5\u987b\u662f\u5728\u9996\u4f4d\uff01", (Object[])new Object[]{firstNecessaryFormRegister.dynamicFormName(), stepRoleFormMapping.getStepName()});
                    Validate.isTrue((boolean)doNot, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f53\u524d\u8868\u5355\u3010%s\u3011\u7684\u6b65\u9aa4\u3010%s\u3011\u7684\u5fc5\u505a\uff01", (Object[])new Object[]{firstNecessaryFormRegister.dynamicFormName(), stepRoleFormMapping.getStepName()});
                    ++firstCount;
                }
                if (lastNecessaryFormRegister != null && StringUtils.equals((CharSequence)stepRoleFormMapping.getFormCode(), (CharSequence)lastNecessaryFormRegister.dynamicFormCode())) {
                    Validate.isTrue((sortNum >= lastSortNum ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f53\u524d\u8868\u5355\u3010%s\u3011\u7684\u6b65\u9aa4\u3010%s\u3011\u7684\u62dc\u8bbf\u987a\u5e8f\u5fc5\u987b\u662f\u5728\u672b\u4f4d\uff01", (Object[])new Object[]{lastNecessaryFormRegister.dynamicFormName(), stepRoleFormMapping.getStepName()});
                    Validate.isTrue((boolean)doNot, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f53\u524d\u8868\u5355\u3010%s\u3011\u7684\u6b65\u9aa4\u3010%s\u3011\u7684\u5fc5\u505a\uff01", (Object[])new Object[]{lastNecessaryFormRegister.dynamicFormName(), stepRoleFormMapping.getStepName()});
                    ++lastCount;
                    continue;
                }
                Validate.isTrue((sortNum < lastSortNum ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7cfb\u7edf\u914d\u7f6e\u7684\u975e\u672b\u4f4d\u8868\u5355\u3010%s\u3011\u6b65\u9aa4\u7684\u62dc\u8bbf\u987a\u5e8f\u5fc5\u987b\u5c0f\u4e8e\u63d0\u4ea4\u7684\u6b65\u9aa4\u8868\u5355\u603b\u6570\uff01", (Object[])new Object[]{lastNecessaryFormRegister.dynamicFormName()});
            }
            Validate.isTrue((firstCount == 1 && lastCount == 1 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u914d\u7f6e\u7684\u8868\u5355\u5fc5\u987b\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u9996\u4f4d\u8868\u5355\u3010%s\u3011\u6b65\u9aa4\u548c\u4e00\u4e2a\u672b\u4f4d\u8868\u5355\u3010%s\u3011\u6b65\u9aa4\uff01", (Object[])new Object[]{firstNecessaryFormRegister.dynamicFormName(), lastNecessaryFormRegister.dynamicFormName()});
        }
    }

    private void buildStepRole(List<StepRole> stepRoles) {
        Map<Object, Object> terminalTypeMap = new HashMap();
        Map<Object, Object> dealerTypeMap = new HashMap();
        ArrayList list = Lists.newArrayList();
        list.add("terminal_type");
        list.add("customer_type");
        Map dictTypeCodeList = this.dictDataVoService.findByDictTypeCodeList((List)list);
        if (dictTypeCodeList != null) {
            List dealerDicts;
            List terminalDicts = (List)dictTypeCodeList.get("terminal_type");
            if (!CollectionUtils.isEmpty((Collection)terminalDicts)) {
                terminalTypeMap = terminalDicts.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
            }
            if (!CollectionUtils.isEmpty((Collection)(dealerDicts = (List)dictTypeCodeList.get("customer_type")))) {
                dealerTypeMap = dealerDicts.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
            }
        }
        for (StepRole stepRole : stepRoles) {
            String clientType = stepRole.getClientType();
            String clientSubType = stepRole.getClientSubType();
            if (ClientTypeEnum.TERMINAL.getDictCode().equals(clientType)) {
                stepRole.setClientSubType((String)terminalTypeMap.get(clientSubType));
            }
            if (!ClientTypeEnum.DEALER.getDictCode().equals(clientType)) continue;
            stepRole.setClientSubType((String)dealerTypeMap.get(clientSubType));
        }
    }

    private Set<String> findRoleCodesByVisitTypes(Set<String> visitTypes) {
        HashSet set = new HashSet();
        if (!CollectionUtils.isEmpty(this.executePlanCallBackStrategies)) {
            for (ExecutePlanCallBackStrategy executePlanCallBackStrategy : this.executePlanCallBackStrategies) {
                if (!visitTypes.contains(executePlanCallBackStrategy.visitType())) continue;
                Set strings = executePlanCallBackStrategy.onFindUserNamesByNowAndExecuteStatusIn();
                set.addAll(strings);
            }
        }
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        Set positionCodes = this.userVoService.findPositionCodesByUserNames((List)Lists.newArrayList(set));
        if (CollectionUtils.isEmpty((Collection)positionCodes)) {
            return null;
        }
        return this.positionVoService.findRolesByPositionCodes((List)Lists.newArrayList((Iterable)positionCodes));
    }
}

