/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.step.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.entity.StepFormLogo;
import com.biz.crm.sfa.business.step.local.entity.StepRole;
import com.biz.crm.sfa.business.step.local.entity.StepRoleFormMapping;
import com.biz.crm.sfa.business.step.local.repository.StepFormLogoRepository;
import com.biz.crm.sfa.business.step.local.repository.StepFormRepository;
import com.biz.crm.sfa.business.step.local.repository.StepRoleFormMappingRepository;
import com.biz.crm.sfa.business.step.local.repository.StepRoleRepository;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.service.StepRoleVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormLogoVo;
import com.biz.crm.sfa.business.step.sdk.vo.StepRoleFormMappingVo;
import com.biz.crm.sfa.business.step.sdk.vo.StepRoleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StepRoleVoServiceImpl
implements StepRoleVoService {
    @Autowired
    private StepFormRepository stepFormRepository;
    @Autowired
    private StepFormLogoRepository stepFormLogoRepository;
    @Autowired
    private StepRoleRepository stepRoleRepository;
    @Autowired
    private StepRoleFormMappingRepository stepRoleFormMappingRepository;
    @Autowired(required=false)
    private PositionVoService positionVoService;
    @Autowired(required=false)
    private UserVoService userVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public List<StepRoleVo> findByUserNameAndClientTypeAndVisitType(String userName, String clientType, String visitType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userName, visitType})) {
            return null;
        }
        List<String> roles = this.findRoleCodesByUserName(userName);
        List<Object> stepRoles = new ArrayList();
        stepRoles = VisitTypeEnum.STRANGE.getDictCode().equals(visitType) ? this.stepRoleRepository.findByVisitTypeAndRoleCodes(visitType, roles) : this.stepRoleRepository.findByVisitTypeAndClientTypeAndRoleCodes(visitType, clientType, roles);
        if (CollectionUtils.isEmpty(stepRoles)) {
            return null;
        }
        List<String> roleIds = stepRoles.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List<StepRoleFormMapping> roleFormMappings = this.stepRoleFormMappingRepository.findByStepRoleIds(roleIds);
        if (CollectionUtils.isEmpty(roleFormMappings)) {
            return null;
        }
        List stepRoleFormMappingVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(roleFormMappings, StepRoleFormMapping.class, StepRoleFormMappingVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<StepRoleFormMappingVo>> stringListMap = stepRoleFormMappingVos.stream().sorted(Comparator.comparingLong(StepRoleFormMappingVo::getSortNum)).collect(Collectors.groupingBy(StepRoleFormMappingVo::getStepRoleId));
        Set<String> stepCodes = roleFormMappings.stream().map(StepRoleFormMapping::getStepCode).collect(Collectors.toSet());
        List<StepForm> stepForms = this.stepFormRepository.findByStepCodes(stepCodes);
        if (CollectionUtils.isEmpty(stepForms)) {
            return null;
        }
        Map<String, StepForm> stringStepFormHashMap = stepForms.stream().collect(Collectors.toMap(StepForm::getStepCode, o -> o));
        List<StepFormLogo> stepFormLogos = this.stepFormLogoRepository.findByStepCodes(stepCodes);
        Map<Object, Object> stringStepFormLogoHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(stepFormLogos)) {
            List stepFormLogoVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(stepFormLogos, StepFormLogo.class, StepFormLogoVo.class, HashSet.class, ArrayList.class, new String[0]);
            stringStepFormLogoHashMap = stepFormLogoVos.stream().collect(Collectors.groupingBy(StepFormLogoVo::getStepCode));
        }
        List stepRoleVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(stepRoles, StepRole.class, StepRoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (StepRoleVo vo : stepRoleVos) {
            List<StepRoleFormMappingVo> roleFormMappingVos = stringListMap.get(vo.getId());
            if (CollectionUtils.isEmpty(roleFormMappingVos)) continue;
            for (StepRoleFormMappingVo roleFormMappingVo : roleFormMappingVos) {
                List formLogos;
                StepForm stepForm = stringStepFormHashMap.get(roleFormMappingVo.getStepCode());
                if (stepForm != null) {
                    BeanUtils.copyProperties((Object)((Object)stepForm), (Object)roleFormMappingVo);
                }
                if (CollectionUtils.isEmpty((Collection)(formLogos = (List)stringStepFormLogoHashMap.get(roleFormMappingVo.getStepCode())))) continue;
                roleFormMappingVo.setLogos(formLogos);
            }
            vo.setRoleFormMappings(roleFormMappingVos);
        }
        return stepRoleVos;
    }

    private List<String> findRoleCodesByUserName(String userName) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        String account = loginDetails.getAccount();
        ArrayList<String> roles = new ArrayList();
        if (account.equals(userName)) {
            roles = loginDetails.getRoles();
        } else {
            Set positionCodes = this.userVoService.findPositionCodesByUserNames((List)Lists.newArrayList((Object[])new String[]{userName}));
            if (CollectionUtils.isEmpty((Collection)positionCodes)) {
                return null;
            }
            Set rolesByPositionCodes = this.positionVoService.findRolesByPositionCodes((List)Lists.newArrayList((Iterable)positionCodes));
            roles = Lists.newArrayList((Iterable)rolesByPositionCodes);
        }
        return roles;
    }
}

