package com.biz.crm.sfa.business.step.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 步骤表单logo表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StepFormLogo", description = "步骤表单logo表")
@Entity
@TableName("sfa_step_form_logo")
@Table(name = "sfa_step_form_logo", indexes = {
    @Index(name = "sfa_step_form_logo_index1", columnList = "step_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_step_form_logo", comment = "步骤表单logo表")
public class StepFormLogo extends FileEntity {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 步骤编码
   */
  @ApiModelProperty("步骤编码")
  @Column(name = "step_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '步骤编码'")
  private String stepCode;

}
