package com.biz.crm.sfa.business.step.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.mapper.StepFormMapper;
import com.biz.crm.sfa.business.step.sdk.dto.StepFormPageDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 步骤表单配置表(StepForm)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-09 14:02:38
 */
@Component
public class StepFormRepository extends ServiceImpl<StepFormMapper, StepForm> {

  @Autowired
  private StepFormMapper stepFormMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<StepForm> findByConditions(Pageable pageable, StepFormPageDto dto) {
    Page<StepForm> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<StepForm> pageList = this.stepFormMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(StepForm::getId, ids)
        .set(StepForm::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 批量物理删除
   *
   * @param idList
   */
  public void updateDelFlagByIds(List<String> idList) {
    this.lambdaUpdate().set(StepForm::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .in(StepForm::getId, idList)
        .update();
  }

  /**
   * 根据步骤编码集合查询步骤信息
   *
   * @param stepCodes
   * @return
   */
  public List<StepForm> findByStepCodes(Set<String> stepCodes) {
    return this.lambdaQuery().in(StepForm::getStepCode, stepCodes).list();
  }

  /**
   * 根据id集合查询数据
   */
  public List<StepForm> findByIds(List<String> idList) {
    return this.lambdaQuery().eq(StepForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(StepForm::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .in(StepForm::getId, idList)
        .list();
  }

  public List<StepForm> findByStepName(String stepName) {
    return this.lambdaQuery().eq(StepForm::getStepName, stepName).list();
  }
}

