package com.biz.crm.sfa.business.step.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.step.local.entity.StepRole;
import com.biz.crm.sfa.business.step.local.mapper.StepRoleMapper;
import com.biz.crm.sfa.business.step.sdk.dto.StepRolePageDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 步骤角色配置表(StepRole)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-13 13:59:33
 */
@Component
public class StepRoleRepository extends ServiceImpl<StepRoleMapper, StepRole> {

  @Autowired
  private StepRoleMapper stepRoleMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<StepRole> findByConditions(Pageable pageable, StepRolePageDto dto) {
    Page<StepRole> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<StepRole> pageList = this.stepRoleMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(StepRole::getId, ids)
        .set(StepRole::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 更新删除状态
   *
   * @param idList
   * @param delFlagStatusEnum
   */
  public void updateDelFlagByIds(List<String> idList, DelFlagStatusEnum delFlagStatusEnum) {
    this.lambdaUpdate()
        .in(StepRole::getId, idList)
        .set(StepRole::getDelFlag, delFlagStatusEnum.getCode())
        .update();
  }

  /**
   * 根据拜访类型和角色编码集合查询数据
   *
   * @param visitType
   * @param roleCodes
   * @return
   */
  public List<StepRole> findByVisitTypeAndRoleCodes(String visitType, List<String> roleCodes) {
    return this.lambdaQuery().eq(StepRole::getVisitType, visitType)
        .eq(StepRole::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(StepRole::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .in(StepRole::getRoleCode, roleCodes)
        .list();
  }

  /**
   * 根据拜访类型和客户类型和角色编码集合查询数据
   *
   * @param visitType
   * @param roleCodes
   * @param clientType
   * @return
   */
  public List<StepRole> findByVisitTypeAndClientTypeAndRoleCodes(String visitType, String clientType, List<String> roleCodes) {
    return this.lambdaQuery().eq(StepRole::getVisitType, visitType)
        .eq(StepRole::getClientType, clientType)
        .eq(StepRole::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(StepRole::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .in(StepRole::getRoleCode, roleCodes)
        .list();
  }

  /**
   * 根据id集合查询可用数据
   *
   * @param ids
   * @return
   */
  public List<StepRole> findByIds(Set<String> ids) {
    return this.lambdaQuery()
        .eq(StepRole::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(StepRole::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(StepRole::getId, ids)
        .list();
  }
}

