package com.biz.crm.sfa.business.step.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.sdk.dto.StepFormPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 步骤表单配置表(StepForm)表服务接口
 *
 * @author songjingen
 * @since 2022-06-09 14:02:38
 */
public interface StepFormService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  Page<StepForm> findByConditions(Pageable pageable, StepFormPageDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  StepForm findById(String id);

  /**
   * 新增数据
   *
   * @param stepForm 实体对象
   * @return 新增结果
   */
  StepForm create(StepForm stepForm);

  /**
   * 修改新据
   *
   * @param stepForm 实体对象
   * @return 修改结果
   */
  StepForm update(StepForm stepForm);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

}

