package com.biz.crm.sfa.business.step.local.service.strategy;

import com.biz.crm.sfa.business.step.local.entity.StepRole;
import com.biz.crm.sfa.business.step.local.entity.StepRoleFormMapping;
import com.biz.crm.sfa.business.step.local.repository.StepRoleFormMappingRepository;
import com.biz.crm.sfa.business.step.local.repository.StepRoleRepository;
import com.biz.crm.sfa.business.step.sdk.strategy.StepFormValidationStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 步骤角色配置策略实现
 *
 * @author songjingen
 * @date 2022/6/30
 */
@Component
public class StepFormRoleValidationStrategy implements StepFormValidationStrategy {

  @Autowired
  private StepRoleFormMappingRepository stepRoleFormMappingRepository;
  @Autowired
  private StepRoleRepository stepRoleRepository;

  @Override
  public void stepCodeUsedValidate(Set<String> stepCodes) {
    if (CollectionUtils.isEmpty(stepCodes)) {
      return;
    }
    List<StepRoleFormMapping> formMappings = this.stepRoleFormMappingRepository.findByStepCodes(stepCodes);
    if (CollectionUtils.isEmpty(formMappings)) {
      return;
    }
    //查看角色配置数据
    Set<String> roleIds = formMappings.stream().map(StepRoleFormMapping::getStepRoleId).collect(Collectors.toSet());
    List<StepRole> stepRoles = this.stepRoleRepository.findByIds(roleIds);
    if (CollectionUtils.isEmpty(stepRoles)) {
      return;
    }
    //过滤出正常使用的角色所用到的步骤表单
    Set<String> ids = stepRoles.stream().map(StepRole::getId).collect(Collectors.toSet());
    Set<StepRoleFormMapping> mappingSet = formMappings.stream().filter(stepRoleFormMapping -> ids.contains(stepRoleFormMapping.getStepRoleId())).collect(Collectors.toSet());
    if (CollectionUtils.isEmpty(mappingSet)) {
      return;
    }
    Set<String> stringSet = mappingSet.stream().map(StepRoleFormMapping::getStepCode).collect(Collectors.toSet());
    throw new RuntimeException("步骤编码" + stringSet + "被使用，不允许禁用或者删除！");
  }
}
