package com.biz.crm.sfa.business.step.sdk.dto;

import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 步骤表单配置分页条件dto
 *
 * @author songjingen
 * @date 2022/6/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StepForm", description = "步骤表单配置分页条件dto")
public class StepFormPageDto implements Serializable {
  private static final long serialVersionUID = 6304238530906344117L;
  /**
   * 租户编码
   */
  private String tenantCode;

  /**
   * 步骤编码
   */
  @ApiModelProperty("步骤编码")
  private String stepCode;

  /**
   * 步骤名称
   */
  @ApiModelProperty("步骤名称")
  private String stepName;
  /**
   * 拜访类型
   *
   * @see VisitTypeEnum#getDictCode()
   */
  @ApiModelProperty("拜访类型")
  private String visitType;

  /**
   * 客户类型
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户细类
   * 取字典编码为经销商：customer_type、终端：terminal_type的数据
   */
  @ApiModelProperty("客户细类，取字典编码为customer_type或者terminal_type的数据")
  private String clientSubType;

  @ApiModelProperty("删除标记")
  private String delFlag;

  @ApiModelProperty("启用状态")
  private String enableStatus;
}
