package com.biz.crm.sfa.business.step.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @description: 有效期类型枚举
 */
public enum DateTypeEnum {

  LONG("long", "long", "长期有效", "1"),
  DEFINITION("definition", "definition", "自定义有效期", "2"),
  ;

  /**
   * 字典key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  DateTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 VisitPlanTypeEnum
   *
   * @param key
   * @return
   */
  public static DateTypeEnum getByKey(String key) {
    return Arrays.stream(DateTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 VisitPlanTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static DateTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(DateTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }

}
