package com.biz.crm.sfa.business.step.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @description: 拜访类型枚举
 */
public enum VisitTypeEnum {

  VISIT("visit", "visit", "拜访", "1"),
  HELP_DEFENSE("helpDefense", "helpDefense", "协访", "2"),
  STRANGE("strange", "strange", "陌拜", "3"),
  ;

  /**
   * 字典key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  VisitTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 VisitPlanTypeEnum
   *
   * @param key
   * @return
   */
  public static VisitTypeEnum getByKey(String key) {
    return Arrays.stream(VisitTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 VisitPlanTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static VisitTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(VisitTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }

}
