package com.biz.crm.sfa.business.step.sdk.strategy;

import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;

import java.util.Set;

/**
 * 执行计划回调策略
 * 上层如果需要执行回调结果，则需要实现该策略
 *
 * @author songjingen
 * @date 2022/6/21
 */
public interface ExecutePlanCallBackStrategy {

  /**
   * 策略对应的拜访类型
   *
   * @return
   * @see VisitTypeEnum#getDictCode()
   */
  String visitType();

  /**
   * 策略对应的拜访类型名称
   *
   * @return
   * @see VisitTypeEnum#getValue()
   */
  String visitName();

  /**
   * 保存完成情况
   *
   * @param parentCode      上层业务编码，所实现模块的业务编码
   * @param dynamicKey      当前关联的动态key，即步骤编码
   * @param dynamicFormCode 表单编码
   */
  void onSave(String parentCode, String dynamicKey, String dynamicFormCode);

  /**
   * 修改拜访状态
   *
   * @param completeOrNot 是否完成状态，true代表状态为已完成拜访，false代表状态正在拜访中
   * @param parentCode    计划明细主键
   */
  void onUpdateExecuteStatus(Boolean completeOrNot, String parentCode);

  /**
   * 查询当前日期（年月日）的执行中的用户账号集合
   *
   * @return 用户账号集合
   */
  Set<String> onFindUserNamesByNowAndExecuteStatusIn();
}
