package com.biz.crm.sfa.business.step.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.DateTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 步骤角色表单关联表vo
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StepRoleFormMappingVo", description = "步骤角色表单关联表vo")
public class StepRoleFormMappingVo extends UuidVo {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 表单角色配置id
   */
  @ApiModelProperty("表单角色配置id")
  private String stepRoleId;

  /**
   * 拜访顺序
   */
  @ApiModelProperty("拜访顺序")
  private Integer sortNum;

  /**
   * 是否必做
   */
  @ApiModelProperty("是否必做")
  private Boolean doNot = false;

  /**
   * 步骤编码
   */
  @ApiModelProperty("步骤编码")
  private String stepCode;

  /**
   * 步骤名称
   */
  @ApiModelProperty("步骤名称")
  private String stepName;

  /**
   * 表单编码
   */
  @ApiModelProperty("表单编码")
  private String formCode;

  /**
   * 表单名称
   */
  @ApiModelProperty("表单名称")
  private String formName;

  /**
   * 拜访类型
   *
   * @see VisitTypeEnum#getDictCode()
   */
  @ApiModelProperty("拜访类型")
  private String visitType;

  /**
   * 客户类型
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户细类
   * 取字典编码为经销商：customer_type、终端：terminal_type的数据
   */
  @ApiModelProperty("客户细类，取字典编码为customer_type或者terminal_type的数据")
  private String clientSubType;

  /**
   * 有效期类型
   *
   * @see DateTypeEnum#getDictCode()
   */
  @ApiModelProperty("有效期类型")
  private String dateType;

  /**
   * 有效期开始日期
   */
  @ApiModelProperty("有效期开始日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date startTime;

  /**
   * 有效期结束日期
   */
  @ApiModelProperty("有效期结束日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date endTime;

  /**
   * 是否获取定位信息
   */
  @ApiModelProperty("是否获取定位信息")
  private Boolean locateType;

  /**
   * 距离限制（米）
   */
  @ApiModelProperty("距离限制（米）")
  private Integer distance;

  /**
   * logo集合
   */
  @ApiModelProperty("logo集合")
  private List<StepFormLogoVo> logos;

}
