package com.biz.crm.sfa.business.step.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 步骤角色配置表vo
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StepRoleVo", description = "步骤表单配置vo")
public class StepRoleVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  private String roleCode;

  /**
   * 角色名称
   */
  @ApiModelProperty("角色名称")
  private String roleName;

  /**
   * 拜访类型
   *
   * @see VisitTypeEnum#getDictCode()
   */
  @ApiModelProperty("拜访类型")
  private String visitType;

  /**
   * 客户类型
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户细类
   * 取字典编码为经销商：customer_type、终端：terminal_type的数据
   */
  @ApiModelProperty("客户细类，取字典编码为customer_type或者terminal_type的数据")
  private String clientSubType;

  /**
   * 是否允许离线操作
   */
  @ApiModelProperty("是否允许离线操作")
  private Boolean offLine = false;

  /**
   * 步骤角色表单关联集合
   */
  @ApiModelProperty("步骤角色表单关联集合")
  private List<StepRoleFormMappingVo> roleFormMappings;
}
