package com.biz.crm.sfa.business.strange.visit.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisit;
import com.biz.crm.sfa.business.strange.visit.local.service.StrangeVisitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 陌拜执行表(StrangeVisit)表相关的http接口
 *
 * @author songjingen
 * @since 2022-08-02 11:24:44
 */
@RestController
@RequestMapping("/v1/strangeVisit/strangeVisit")
@Slf4j
@Api(tags = "陌拜执行：StrangeVisit：陌拜执行表")
public class StrangeVisitController {
  /**
   * 服务对象
   */
  @Autowired
  private StrangeVisitService strangeVisitService;

  /**
   * 新增数据
   *
   * @param strangeVisit 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<StrangeVisit> create(@ApiParam(name = "strangeVisit", value = "陌拜执行表") @RequestBody StrangeVisit strangeVisit) {
    try {
      StrangeVisit result = this.strangeVisitService.create(strangeVisit);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
