package com.biz.crm.sfa.business.strange.visit.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisitPerformance;
import com.biz.crm.sfa.business.strange.visit.local.service.StrangeVisitPerformanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 陌拜执行完成情况表(StrangeVisitPerformance)表相关的http接口
 *
 * @author songjingen
 * @since 2022-08-02 11:24:44
 */
@RestController
@RequestMapping("/v1/strangeVisit/strangeVisitPerformance")
@Slf4j
@Api(tags = "陌拜执行：StrangeVisitPerformance：陌拜执行完成情况表")
public class StrangeVisitPerformanceController {
  /**
   * 服务对象
   */
  @Autowired
  private StrangeVisitPerformanceService strangeVisitPerformanceService;

  /**
   * 根据陌拜执行主键查询已完成表单数据
   *
   * @param id 主键
   * @return
   */
  @GetMapping("findByDetailId")
  @ApiOperation(value = "根据陌拜执行主键查询已完成表单数据")
  public Result<List<StrangeVisitPerformance>> findByDetailId(@ApiParam(name = "id", value = "主键") @RequestParam("id") String id) {
    try {
      List<StrangeVisitPerformance> list = this.strangeVisitPerformanceService.findByDetailId(id);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
