package com.biz.crm.sfa.business.strange.visit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.sfa.business.strange.visit.sdk.enums.StrangeStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 陌拜执行 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_strange_visit")
@Table(name = "sfa_strange_visit", indexes = {
    @Index(name = "sfa_strange_visit_index1", columnList = "client_code,visit_user_name,visit_date", unique = true),
})
@ApiModel(value = "StrangeVisit", description = "陌拜执行表")
@org.hibernate.annotations.Table(appliesTo = "sfa_strange_visit", comment = "陌拜执行表")
public class StrangeVisit extends UuidOpEntity {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "client_name", length = 64, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientName;

  /**
   * 陌拜状态
   * {@link StrangeStatusEnum#getDictCode()}
   */
  @ApiModelProperty("陌拜状态")
  @Column(name = "strange_status", length = 64, nullable = false, columnDefinition = "varchar(255) COMMENT '陌拜状态'")
  private String strangeStatus;

  /**
   * 拜访日期
   */
  @ApiModelProperty("拜访日期")
  @Column(name = "visit_date", length = 20, nullable = false, columnDefinition = "date COMMENT '拜访日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date visitDate;

  /**
   * 拜访年月
   */
  @ApiModelProperty("拜访年月")
  @Column(name = "visit_year_month", length = 7, columnDefinition = "varchar(7) COMMENT '拜访年月'")
  private String visitYearMonth;

  /**
   * 拜访开始时间
   */
  @ApiModelProperty("拜访开始时间")
  @Column(name = "visit_start_date", length = 20, columnDefinition = "datetime COMMENT '拜访开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitStartDate;

  /**
   * 拜访结束时间
   */
  @ApiModelProperty("拜访结束时间")
  @Column(name = "visit_end_date", length = 20, columnDefinition = "datetime COMMENT '拜访结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitEndDate;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  @Column(name = "visit_user_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '人员账号'")
  private String visitUserName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  @Column(name = "visit_real_name", length = 255, columnDefinition = "varchar(255) COMMENT '人员姓名'")
  private String visitRealName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  @Column(name = "visit_post_code", length = 64, columnDefinition = "varchar(64) COMMENT '人员职位编码'")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  @Column(name = "visit_post_name", length = 255, columnDefinition = "varchar(255) COMMENT '人员职位名称'")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  @Column(name = "visit_org_code", length = 64, columnDefinition = "varchar(64) COMMENT '人员所属组织编码'")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  @Column(name = "visit_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '人员所属组织名称'")
  private String visitOrgName;


}
