package com.biz.crm.sfa.business.strange.visit.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisitPerformance;
import com.biz.crm.sfa.business.strange.visit.local.mapper.StrangeVisitPerformanceMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 陌拜执行完成情况表(StrangeVisitPerformance)表数据库访问层
 *
 * @author songjingen
 * @since 2022-08-02 11:24:44
 */
@Component
public class StrangeVisitPerformanceRepository extends ServiceImpl<StrangeVisitPerformanceMapper, StrangeVisitPerformance> {


  /**
   * 根据主键查询数据
   *
   * @param id
   * @return
   */
  public List<StrangeVisitPerformance> findByDetailId(String id) {
    return this.lambdaQuery().eq(StrangeVisitPerformance::getStrangeVisitId, id)
        .orderByAsc(StrangeVisitPerformance::getCreateTime)
        .list();
  }
}

