package com.biz.crm.sfa.business.strange.visit.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisit;
import com.biz.crm.sfa.business.strange.visit.local.mapper.StrangeVisitMapper;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 陌拜执行表(StrangeVisit)表数据库访问层
 *
 * @author songjingen
 * @since 2022-08-02 11:24:44
 */
@Component
public class StrangeVisitRepository extends ServiceImpl<StrangeVisitMapper, StrangeVisit> {

  /**
   * 根据客户编码和人员账号和时间查询执行计划
   *
   * @param clientCodes
   * @return
   */
  public List<StrangeVisit> findByClientCodesAndUserNameAndVisitDate(Set<String> clientCodes, String userName, Date visitDate) {
    return this.lambdaQuery()
        .eq(StrangeVisit::getVisitUserName, userName)
        .eq(StrangeVisit::getVisitDate, visitDate)
        .in(StrangeVisit::getClientCode, clientCodes)
        .list();
  }

  /**
   * 根据用户账号和拜访日期查询数据
   *
   * @param visitDate
   * @param account
   * @return
   */
  public List<StrangeVisit> findByVisitDateAndUserName(Date visitDate, String account) {
    return this.lambdaQuery().eq(StrangeVisit::getVisitDate, visitDate).eq(StrangeVisit::getVisitUserName, account).list();
  }

  /**
   * 查询根据时间和拜访状态查询数据
   *
   * @param visitDate
   * @param strangeStatus
   * @return
   */
  public List<StrangeVisit> findUserNamesByNowAndExecuteStatusIn(Date visitDate, String strangeStatus) {
    return this.lambdaQuery().eq(StrangeVisit::getVisitDate, visitDate).eq(StrangeVisit::getStrangeStatus, strangeStatus).list();
  }
}

