package com.biz.crm.sfa.business.strange.visit.local.service.internal;


import com.biz.crm.sfa.business.step.sdk.service.StepFormVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormVo;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisitPerformance;
import com.biz.crm.sfa.business.strange.visit.local.repository.StrangeVisitPerformanceRepository;
import com.biz.crm.sfa.business.strange.visit.local.service.StrangeVisitPerformanceService;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateModelDto;
import com.biz.crm.sfa.business.template.sdk.service.DynamicTemplateService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 陌拜执行完成情况表(StrangeVisitPerformance)表服务实现类
 *
 * @author songjingen
 * @since 2022-08-02 11:24:44
 */
@Service("strangeVisitPerformanceService")
public class StrangeVisitPerformanceServiceImpl implements StrangeVisitPerformanceService {

  @Autowired
  private StrangeVisitPerformanceRepository strangeVisitPerformanceRepository;

  @Autowired(required = false)
  private StepFormVoService stepFormVoService;

  @Autowired
  private DynamicTemplateService dynamicTemplateService;

  /**
   * 新增数据
   *
   * @param strangeVisitPerformance 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public StrangeVisitPerformance create(StrangeVisitPerformance strangeVisitPerformance) {
    this.createValidate(strangeVisitPerformance);
    this.strangeVisitPerformanceRepository.saveOrUpdate(strangeVisitPerformance);
    return strangeVisitPerformance;
  }

  @Override
  public List<StrangeVisitPerformance> findByDetailId(String id) {
    if (StringUtils.isBlank(id)) {
      return new ArrayList<>();
    }
    List<StrangeVisitPerformance> list = this.strangeVisitPerformanceRepository.findByDetailId(id);
    if (CollectionUtils.isEmpty(list)) {
      return new ArrayList<>(0);
    }
    Set<String> stepCodes = list.stream().map(StrangeVisitPerformance::getStepCode).collect(Collectors.toSet());
    List<StepFormVo> stepFormVos = this.stepFormVoService.findByStepCodes(stepCodes);
    if (CollectionUtils.isEmpty(stepCodes)) {
      return new ArrayList<>(0);
    }
    Map<String, StepFormVo> stepFormVoMap = stepFormVos.stream().collect(Collectors.toMap(StepFormVo::getStepCode, o -> o));
    for (StrangeVisitPerformance performance : list) {
      StepFormVo stepFormVo = stepFormVoMap.get(performance.getStepCode());
      if (stepFormVo != null) {
        performance.setStepName(stepFormVo.getStepName());
        performance.setLogos(stepFormVo.getLogos());
      }
      //组装步骤数据
      DynamicTemplateModelDto dynamicTemplateModelDto = new DynamicTemplateModelDto();
      dynamicTemplateModelDto.setParentCode(performance.getStrangeVisitId());
      dynamicTemplateModelDto.setDynamicKey(performance.getStepCode());
      dynamicTemplateModelDto.setDynamicFormCode(performance.getFormCode());
      AbstractDynamicTemplateModel model = dynamicTemplateService.findByDynamicTemplateModelDto(dynamicTemplateModelDto);
      performance.setAbstractDynamicTemplateModel(model);
    }
    return list;
  }

  /**
   * 创建验证
   *
   * @param strangeVisitPerformance
   */
  private void createValidate(StrangeVisitPerformance strangeVisitPerformance) {
    Validate.notNull(strangeVisitPerformance, "新增时，对象信息不能为空！");
    strangeVisitPerformance.setId(null);
    Validate.notBlank(strangeVisitPerformance.getStepCode(), "新增数据时，步骤编码不能为空！");
    Validate.notBlank(strangeVisitPerformance.getStrangeVisitId(), "新增数据时，陌拜执行id不能为空！");

  }

}

