package com.biz.crm.sfa.business.strange.visit.local.service.internal;


import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisit;
import com.biz.crm.sfa.business.strange.visit.local.repository.StrangeVisitRepository;
import com.biz.crm.sfa.business.strange.visit.local.service.StrangeVisitService;
import com.biz.crm.sfa.business.strange.visit.sdk.enums.StrangeStatusEnum;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 陌拜执行表(StrangeVisit)表服务实现类
 *
 * @author songjingen
 * @since 2022-08-02 11:24:44
 */
@Service("strangeVisitService")
public class StrangeVisitServiceImpl implements StrangeVisitService {

  @Autowired
  private StrangeVisitRepository strangeVisitRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 新增数据
   *
   * @param strangeVisit 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public StrangeVisit create(StrangeVisit strangeVisit) {
    this.createValidate(strangeVisit);
    this.strangeVisitRepository.saveOrUpdate(strangeVisit);
    return strangeVisit;
  }

  @Override
  public List<StrangeVisit> findByClientCodesAndUserNameAndVisitDate(Set<String> clientCodes, String userName, Date visitDate) {
    if (CollectionUtils.isEmpty(clientCodes) || StringUtils.isBlank(userName) || visitDate == null) {
      return new ArrayList<>(0);
    }
    return this.strangeVisitRepository.findByClientCodesAndUserNameAndVisitDate(clientCodes, userName, visitDate);
  }

  /**
   * 创建验证
   *
   * @param strangeVisit
   */
  private void createValidate(StrangeVisit strangeVisit) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    Validate.notNull(strangeVisit, "新增时，对象信息不能为空！");
    strangeVisit.setId(null);
    strangeVisit.setStrangeStatus(StrangeStatusEnum.NOT_VISIT.getDictCode());
    Validate.notBlank(strangeVisit.getClientCode(), "新增数据时，客户编码不能为空！");
    Validate.notNull(strangeVisit.getVisitDate(), "新增数据时，拜访日期不能为空！");
    Validate.notBlank(strangeVisit.getStrangeStatus(), "新增数据时，拜访状态不能为空！");
    Validate.notBlank(strangeVisit.getVisitUserName(), "新增数据时，人员账号不能为空！");
    if (loginDetails.getAccount().equals(strangeVisit.getVisitUserName())) {
      strangeVisit.setVisitRealName(loginDetails.getUsername());
      strangeVisit.setVisitOrgCode(loginDetails.getOrgCode());
      strangeVisit.setVisitOrgName(loginDetails.getOrgName());
      strangeVisit.setVisitPostCode(loginDetails.getPostCode());
      strangeVisit.setVisitPostName(loginDetails.getPostName());
    }
    //同一客户当天只能被同一业务员拜访一次
    List<StrangeVisit> byClientCodesAndUserNameAndVisitDate = this.strangeVisitRepository.findByClientCodesAndUserNameAndVisitDate(Sets.newHashSet(strangeVisit.getClientCode()), strangeVisit.getVisitUserName(), strangeVisit.getVisitDate());
    Validate.isTrue(CollectionUtils.isEmpty(byClientCodesAndUserNameAndVisitDate), "已经拜访过当前客户！");
  }

}

