package com.biz.crm.sfa.business.strange.visit.local.service.strategy;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.strategy.ExecutePlanCallBackStrategy;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisit;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisitPerformance;
import com.biz.crm.sfa.business.strange.visit.local.repository.StrangeVisitRepository;
import com.biz.crm.sfa.business.strange.visit.local.service.StrangeVisitPerformanceService;
import com.biz.crm.sfa.business.strange.visit.sdk.enums.StrangeStatusEnum;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 拜访步骤完成情况回调监听事件实现类
 *
 * @author songjingen
 * @date 2022/6/21
 */
@Component
public class ExecutePlanCallBackStrategyForStrange implements ExecutePlanCallBackStrategy {

  @Autowired
  private StrangeVisitPerformanceService strangeVisitPerformanceService;
  @Autowired
  private StrangeVisitRepository strangeVisitRepository;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public String visitType() {
    return VisitTypeEnum.STRANGE.getDictCode();
  }

  @Override
  public String visitName() {
    return VisitTypeEnum.STRANGE.getValue();
  }

  @Transactional
  @Override
  public void onSave(String parentCode, String dynamicKey, String dynamicFormCode) {
    Validate.notBlank(parentCode, "保存完成情况时，父级关联唯一编码（明细id）不能为空！");
    Validate.notBlank(dynamicKey, "保存完成情况时，动态key（步骤编码）不能为空！");
    Validate.notBlank(dynamicFormCode, "保存完成情况时，表单编码不能为空！");
    StrangeVisitPerformance helpDefensePlanDetailPerformance = new StrangeVisitPerformance();
    helpDefensePlanDetailPerformance.setStrangeVisitId(parentCode);
    helpDefensePlanDetailPerformance.setStepCode(dynamicKey);
    helpDefensePlanDetailPerformance.setFormCode(dynamicFormCode);
    this.strangeVisitPerformanceService.create(helpDefensePlanDetailPerformance);
  }

  @Override
  public void onUpdateExecuteStatus(Boolean completeOrNot, String parentCode) {
    Date planDateTime = new Date();
    StrangeVisit strangeVisit = this.strangeVisitRepository.getById(parentCode);
    if (completeOrNot) {
      strangeVisit.setStrangeStatus(StrangeStatusEnum.VISIT_TO_COMPLETE.getDictCode());
      strangeVisit.setVisitEndDate(planDateTime);
    } else {
      //验证是否存在相同时间的拜访中数据
      FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
      List<StrangeVisit> byUserNameAndVisitDate = this.strangeVisitRepository.findByVisitDateAndUserName(strangeVisit.getVisitDate(), loginDetails.getAccount());
      List<StrangeVisit> planDetails = byUserNameAndVisitDate.stream().filter(detail -> detail.getStrangeStatus().equals(StrangeStatusEnum.IN_THE_VISIT.getDictCode())).collect(Collectors.toList());
      Validate.isTrue(CollectionUtils.isEmpty(planDetails), "存在拜访中的计划，请完成后再次拜访！");
      strangeVisit.setStrangeStatus(StrangeStatusEnum.IN_THE_VISIT.getDictCode());
      if (strangeVisit.getVisitEndDate() == null) {
        strangeVisit.setVisitStartDate(planDateTime);
      }
    }
    this.strangeVisitRepository.saveOrUpdate(strangeVisit);
  }

  @Override
  public Set<String> onFindUserNamesByNowAndExecuteStatusIn() {
    try {
      String nowDateStr = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
      Date nowDate = DateUtils.parseDate(nowDateStr, "yyyy-MM-dd");
      List<StrangeVisit> list = this.strangeVisitRepository.findUserNamesByNowAndExecuteStatusIn(nowDate, StrangeStatusEnum.IN_THE_VISIT.getDictCode());
      if (CollectionUtils.isEmpty(list)) {
        return new HashSet<>(0);
      }
      return list.stream().map(StrangeVisit::getVisitUserName).collect(Collectors.toSet());
    } catch (ParseException e) {
      e.printStackTrace();
    }
    return null;
  }

}
