package com.biz.crm.sfa.business.strange.visit.local.service.strategy;

import com.biz.crm.business.common.sdk.utils.DistanceUtil;
import com.biz.crm.common.gaode.sdk.service.GaoDeAroundService;
import com.biz.crm.common.gaode.sdk.vo.GaoDeNearbyVo;
import com.biz.crm.sfa.business.template.sdk.strategy.StrangeVisitValidateLocationStrategy;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author songjingen
 * @date 2022/8/2
 */
@Component
public class StrangeVisitValidateLocationForGaoDeStrategy implements StrangeVisitValidateLocationStrategy {

  @Autowired(required = false)
  private GaoDeAroundService gaoDeAroundService;

  @Override
  public String key() {
    return "gaoDe";
  }

  @Override
  public String name() {
    return "高德";
  }

  @Override
  public void onValidate(String mapId, BigDecimal longitude, BigDecimal latitude, Integer distance) {
    GaoDeNearbyVo byId = this.gaoDeAroundService.findById(mapId);
    Validate.notNull(byId, "验证定位时，未查询到高德信息");
    String longitudeParam = byId.getLongitude();
    String latitudeParam = byId.getLatitude();
    Validate.notNull(longitudeParam, "当前站点没有配置位置（经度）信息");
    Validate.notNull(latitudeParam, "当前站点没有配置位置（纬度）信息");
    double currentDistance = DistanceUtil.calculatePointDistance(latitude.doubleValue(), longitude.doubleValue(), Double.valueOf(latitudeParam), Double.valueOf(longitudeParam));
    Validate.isTrue(BigDecimal.valueOf(currentDistance).compareTo(BigDecimal.valueOf(distance)) <= 0, "请在拜访范围内进行客户拜访！");
  }

}
