/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.strange.visit.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.strange.visit.local.entity.StrangeVisit;
import com.biz.crm.sfa.business.strange.visit.local.repository.StrangeVisitRepository;
import com.biz.crm.sfa.business.strange.visit.local.service.StrangeVisitService;
import com.biz.crm.sfa.business.strange.visit.sdk.enums.StrangeStatusEnum;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="strangeVisitService")
public class StrangeVisitServiceImpl
implements StrangeVisitService {
    @Autowired
    private StrangeVisitRepository strangeVisitRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public StrangeVisit create(StrangeVisit strangeVisit) {
        this.createValidate(strangeVisit);
        this.strangeVisitRepository.saveOrUpdate((Object)strangeVisit);
        return strangeVisit;
    }

    @Override
    public List<StrangeVisit> findByClientCodesAndUserNameAndVisitDate(Set<String> clientCodes, String userName, Date visitDate) {
        if (CollectionUtils.isEmpty(clientCodes) || StringUtils.isBlank((CharSequence)userName) || visitDate == null) {
            return new ArrayList<StrangeVisit>(0);
        }
        return this.strangeVisitRepository.findByClientCodesAndUserNameAndVisitDate(clientCodes, userName, visitDate);
    }

    private void createValidate(StrangeVisit strangeVisit) {
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        Validate.notNull((Object)((Object)strangeVisit), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        strangeVisit.setId(null);
        strangeVisit.setStrangeStatus(StrangeStatusEnum.NOT_VISIT.getDictCode());
        Validate.notBlank((CharSequence)strangeVisit.getClientCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)strangeVisit.getVisitDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)strangeVisit.getStrangeStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)strangeVisit.getVisitUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (loginDetails.getAccount().equals(strangeVisit.getVisitUserName())) {
            strangeVisit.setVisitRealName(loginDetails.getUsername());
            strangeVisit.setVisitOrgCode(loginDetails.getOrgCode());
            strangeVisit.setVisitOrgName(loginDetails.getOrgName());
            strangeVisit.setVisitPostCode(loginDetails.getPostCode());
            strangeVisit.setVisitPostName(loginDetails.getPostName());
        }
        List<StrangeVisit> byClientCodesAndUserNameAndVisitDate = this.strangeVisitRepository.findByClientCodesAndUserNameAndVisitDate(Sets.newHashSet((Object[])new String[]{strangeVisit.getClientCode()}), strangeVisit.getVisitUserName(), strangeVisit.getVisitDate());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(byClientCodesAndUserNameAndVisitDate), (String)"\u5df2\u7ecf\u62dc\u8bbf\u8fc7\u5f53\u524d\u5ba2\u6237\uff01", (Object[])new Object[0]);
    }
}

