package com.biz.crm.sfa.business.strange.visit.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @description: 拜访状态枚举
 */
public enum StrangeStatusEnum {

  NOT_VISIT("0", "0", "未拜访", "1"),
  IN_THE_VISIT("1", "1", "拜访中", "2"),
  VISIT_TO_COMPLETE("2", "2", "拜访完成", "3"),
  EXCEPTION("3", "3", "异常", "4"),
  ;

  /**
   * 字典key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  StrangeStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 VisitPlanTypeEnum
   *
   * @param key
   * @return
   */
  public static StrangeStatusEnum getByKey(String key) {
    return Arrays.stream(StrangeStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 VisitPlanTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static StrangeStatusEnum getByDictCode(String dictCode) {
    return Arrays.stream(StrangeStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }

}
